/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.execution;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.ExecutionPane;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tabs.execution.ActivityItem;
import org.cristalise.gui.tabs.execution.Executor;
import org.cristalise.gui.tabs.execution.RequestButton;
import org.cristalise.gui.tabs.outcome.InvalidOutcomeException;
import org.cristalise.gui.tabs.outcome.InvalidSchemaException;
import org.cristalise.gui.tabs.outcome.OutcomeHandler;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class ActivityViewer
extends JPanel
implements Runnable {
    ItemProxy item;
    Box outcomeButtons = Box.createHorizontalBox();
    OutcomeHandler outcomePanel;
    OutcomeHandler errorPanel;
    JPanel outcomeView = new JPanel(new GridLayout(1, 1));
    JPanel errorView = new JPanel(new GridLayout(2, 1));
    ActivityItem thisAct;
    ArrayList<RequestButton> requestButtons = new ArrayList();
    JLabel noOutcome = new JLabel("No outcome data is required for this activity");
    ExecutionPane parent;
    JLabel status;
    JComboBox executors;
    JButton saveButton = new JButton("Save");
    JButton loadButton = new JButton("Load");
    GridBagLayout gridbag = new GridBagLayout();
    Job executingJob = null;
    static JFileChooser chooser = new JFileChooser();

    public ActivityViewer(ActivityItem newAct, ItemProxy item, ExecutionPane parent) {
        String roleName;
        this.thisAct = newAct;
        this.item = item;
        this.parent = parent;
        this.setLayout(this.gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 18;
        c.fill = 2;
        Job firstJob = this.thisAct.getJobs().get(0);
        String desc = firstJob.getDescription();
        if (desc != null && desc.length() > 0) {
            Box descBox = Box.createHorizontalBox();
            String chopDesc = null;
            chopDesc = desc.length() >= 80 ? desc.substring(0, 80) : desc;
            descBox.add(new JLabel("Description: " + chopDesc));
            if (desc.length() > chopDesc.length()) {
                descBox.add(new JLabel(" ..."));
                descBox.add(Box.createHorizontalStrut(7));
                JButton descButton = new JButton("View");
                descButton.setMargin(new Insets(0, 0, 0, 0));
                descButton.setActionCommand(desc);
                descButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JTextArea descArea = new JTextArea(e.getActionCommand());
                        descArea.setLineWrap(true);
                        descArea.setWrapStyleWord(true);
                        JScrollPane descScroll = new JScrollPane(descArea);
                        descScroll.setPreferredSize(new Dimension(400, 150));
                        JOptionPane.showMessageDialog(null, descScroll, "Activity Description", -1);
                    }
                });
                descBox.add(descButton);
            }
            this.gridbag.setConstraints(descBox, c);
            this.add(descBox);
        }
        if ((roleName = firstJob.getAgentRole()) != null && roleName.length() > 0) {
            ++c.gridy;
            JLabel role = new JLabel("Agent Role: " + roleName);
            this.gridbag.setConstraints(role, c);
            this.add(role);
        }
        ++c.gridy;
        c.anchor = 13;
        this.gridbag.setConstraints(this.outcomeButtons, c);
        this.add(this.outcomeButtons);
        this.executors = MainFrame.getExecutionPlugins();
        if (this.executors.getItemCount() > 1) {
            ++c.gridx;
            this.gridbag.setConstraints(this.executors, c);
            this.add(this.executors);
            --c.gridx;
        }
        ++c.gridy;
        this.status = new JLabel("Waiting for request");
        this.status.setFont(ItemTabPane.titleFont);
        this.gridbag.setConstraints(this.status, c);
        this.add(this.status);
        ++c.gridx;
        Box fileBox = Box.createHorizontalBox();
        fileBox.add(this.saveButton);
        fileBox.add(Box.createHorizontalGlue());
        fileBox.add(this.loadButton);
        this.gridbag.setConstraints(fileBox, c);
        this.add(fileBox);
        this.saveButton.setEnabled(false);
        this.loadButton.setEnabled(false);
        --c.gridx;
        c.gridwidth = 2;
        Iterator<Job> iterator = this.thisAct.getJobs().iterator();
        while (iterator.hasNext()) {
            Job name2;
            Job thisJob = name2 = iterator.next();
            RequestButton newButton = new RequestButton(thisJob, this);
            this.requestButtons.add(newButton);
            this.outcomeButtons.add(newButton);
            this.outcomeButtons.add(Box.createHorizontalStrut(5));
            newButton.setEnabled(false);
            if (thisJob.hasOutcome()) {
                Schema schema;
                try {
                    schema = thisJob.getSchema();
                }
                catch (Exception e) {
                    newButton.setToolTipText("Could not load schema for this job.");
                    continue;
                }
                if (!schema.getName().equals("Errors") && this.outcomePanel == null) {
                    try {
                        this.outcomePanel = this.getOutcomeHandler(thisJob);
                        this.outcomeView = this.outcomePanel.getPanel();
                        newButton.setEnabled(true);
                    }
                    catch (ObjectNotFoundException ex) {
                        this.outcomeView.add(new JLabel("Schema not found: " + schema.getName() + " v" + schema.getVersion()));
                    }
                    catch (Exception ex) {
                        this.outcomeView.add(new JLabel("ERROR loading outcome editor: " + ex.getClass().getName() + " (" + ex.getMessage() + ")"));
                        Logger.error((Throwable)ex);
                    }
                }
                if (!schema.getName().equals("Errors")) continue;
                try {
                    this.errorPanel = this.getOutcomeHandler(thisJob);
                    this.errorView.add(this.errorPanel.getPanel());
                    newButton.setEnabled(true);
                }
                catch (Exception ex) {
                    this.errorView.add(new JLabel("ERROR loading error editor: " + ex.getClass().getName() + " (" + ex.getMessage() + ")"));
                }
                continue;
            }
            newButton.setEnabled(true);
        }
        if (this.outcomePanel == null) {
            this.outcomeView.add(this.noOutcome);
        } else {
            this.enableLoadSaveButtons();
        }
        ++c.gridy;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        this.gridbag.setConstraints(this.outcomeView, c);
        this.add(this.outcomeView);
    }

    public OutcomeHandler getOutcomeHandler(Job thisJob) throws ObjectNotFoundException, InvalidSchemaException, InvalidOutcomeException, InvalidDataException {
        Schema schema = thisJob.getSchema();
        OutcomeHandler thisForm = ItemTabPane.getOutcomeHandler(schema.getName(), schema.getVersion());
        thisForm.setReadOnly(false);
        thisForm.setDescription(schema.getSchemaData());
        String outcomeString = thisJob.getOutcomeString();
        if (outcomeString != null && outcomeString.length() > 0) {
            thisForm.setOutcome(outcomeString);
        }
        return thisForm;
    }

    public void enableLoadSaveButtons() {
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String output = ActivityViewer.this.outcomePanel.getOutcome();
                    int returnVal = chooser.showSaveDialog(null);
                    if (returnVal == 0) {
                        File targetFile = chooser.getSelectedFile();
                        if (!targetFile.getAbsolutePath().endsWith(".xml")) {
                            targetFile = new File(targetFile.getAbsolutePath() + ".xml");
                        }
                        Logger.msg((int)2, (String)("ExecutionPane - Exporting outcome to file " + targetFile.getName()));
                        FileStringUtility.string2File((File)targetFile, (String)output);
                    }
                }
                catch (Exception ex) {
                    Logger.error((Throwable)ex);
                    MainFrame.exceptionDialog(ex);
                }
            }
        });
        this.saveButton.setEnabled(true);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        File targetFile = chooser.getSelectedFile();
                        Logger.msg((int)2, (String)("ViewpointPane.actionPerformed() - Reading outcome from file " + targetFile.getName()));
                        String outcome = FileStringUtility.file2String((File)targetFile);
                        ActivityViewer.this.outcomePanel.setOutcome(outcome);
                        new Thread(ActivityViewer.this.outcomePanel).start();
                    }
                }
                catch (Exception ex) {
                    Logger.error((Throwable)ex);
                    MainFrame.exceptionDialog(ex);
                }
            }
        });
        this.loadButton.setEnabled(true);
    }

    public void init() {
        if (this.outcomePanel != null) {
            new Thread(this.outcomePanel).start();
        }
        if (this.errorPanel != null) {
            new Thread(this.errorPanel).start();
        }
    }

    public void execute(Job thisJob) {
        try {
            if (thisJob.hasOutcome()) {
                if (!thisJob.getSchema().getName().equals("Errors")) {
                    thisJob.setOutcome(this.outcomePanel.getOutcome());
                } else {
                    Box errorBox = Box.createVerticalBox();
                    errorBox.add(new JLabel("Please give details of the error:"));
                    errorBox.add(this.errorView);
                    int result = JOptionPane.showConfirmDialog(this, errorBox, "Send Error", 2, 0);
                    if (result != 0) {
                        return;
                    }
                    thisJob.setOutcome(this.errorPanel.getOutcome());
                }
            }
            this.executingJob = thisJob;
            new Thread(this).start();
        }
        catch (Exception ex) {
            MainFrame.exceptionDialog(ex);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Activity Execution");
        this.enableAllButtons(false);
        try {
            Executor selectedExecutor = (Executor)this.executors.getSelectedItem();
            selectedExecutor.execute(this.executingJob, this.status);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            MainFrame.progress.stopBouncing("Error during execution");
            this.status.setText("Error during execution: " + e.getClass().getSimpleName());
            MainFrame.exceptionDialog(e);
        }
        this.enableAllButtons(true);
    }

    private void enableAllButtons(boolean enabled) {
        for (RequestButton thisButton : this.requestButtons) {
            thisButton.setEnabled(enabled);
        }
    }

    public ActivityItem getActivity() {
        return this.thisAct;
    }

    static {
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML Files";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().endsWith(".xml");
            }
        });
    }
}

