/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.cristalise.gui.tabs.outcome.form.field.EditField;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AttributeList
extends JPanel {
    ArrayList<EditField> attrSet = new ArrayList();
    ElementDecl model;
    Element myElement;
    boolean readOnly;
    static Font labelFont;

    public AttributeList(ElementDecl model, boolean readOnly) {
        this.model = model;
        this.readOnly = readOnly;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        if (labelFont == null) {
            labelFont = this.getFont().deriveFont((float)((double)this.getFont().getSize() - 3.0));
        }
        if (!model.getType().isComplexType()) {
            return;
        }
        ComplexType content = (ComplexType)model.getType();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.ipadx = 5;
        c.ipady = 0;
        Enumeration fields = content.getAttributeDecls();
        while (fields.hasMoreElements()) {
            c.gridy = 0;
            AttributeDecl thisDecl = (AttributeDecl)fields.nextElement();
            Logger.msg((int)8, (String)("Includes Attribute " + thisDecl.getName()));
            String helpText = null;
            String doc = OutcomeStructure.extractHelp((Annotated)thisDecl);
            if (doc.length() > 0) {
                helpText = doc.toString();
            }
            JLabel heading = OutcomeStructure.makeLabel(thisDecl.getName(), helpText);
            gridbag.setConstraints(heading, c);
            this.add(heading);
            ++c.gridy;
            try {
                EditField entry = EditField.getEditField(thisDecl);
                this.attrSet.add(entry);
                if (readOnly) {
                    entry.setEditable(false);
                }
                gridbag.setConstraints(entry.getControl(), c);
                this.add(entry.getControl());
            }
            catch (StructuralException e) {
                JLabel entry = new JLabel("Error");
                entry.setToolTipText(e.getMessage());
                gridbag.setConstraints(entry, c);
                this.add(entry);
            }
            ++c.gridx;
        }
    }

    public void setInstance(Element data) throws StructuralException {
        this.myElement = data;
        for (EditField thisField : this.attrSet) {
            Logger.msg((int)8, (String)("Populating Attribute " + thisField.getName()));
            Attr thisAttr = this.myElement.getAttributeNode(thisField.getName());
            if (thisAttr == null) {
                thisAttr = this.newAttribute(this.myElement, (AttributeDecl)thisField.getModel());
            }
            thisField.setData(thisAttr);
        }
    }

    public Attr newAttribute(Element parent, AttributeDecl attr) {
        parent.setAttribute(attr.getName(), attr.getFixedValue() != null ? attr.getFixedValue() : attr.getDefaultValue());
        return parent.getAttributeNode(attr.getName());
    }

    public String validateAttributes() {
        if (this.model.getType().isComplexType()) {
            ComplexType content = (ComplexType)this.model.getType();
            Enumeration fields = content.getAttributeDecls();
            while (fields.hasMoreElements()) {
                AttributeDecl thisDecl = (AttributeDecl)fields.nextElement();
                String attrVal = this.myElement.getAttribute(thisDecl.getName());
                if (attrVal.length() != 0 || !thisDecl.isOptional()) continue;
                this.myElement.removeAttribute(thisDecl.getName());
            }
        }
        return null;
    }

    public void initNew(Element parent) {
        this.myElement = parent;
        if (this.model.getType().isSimpleType()) {
            return;
        }
        ComplexType content = (ComplexType)this.model.getType();
        for (EditField thisField : this.attrSet) {
            AttributeDecl thisDecl = content.getAttributeDecl(thisField.getName());
            if (thisDecl.isReference()) {
                thisDecl = thisDecl.getReference();
            }
            Attr thisAttr = this.newAttribute(this.myElement, thisDecl);
            try {
                thisField.setData(thisAttr);
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public void grabFocus() {
        if (this.attrSet.size() > 0) {
            this.attrSet.get(0).grabFocus();
        }
    }
}

