/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.form.AttributeList;
import org.cristalise.gui.tabs.outcome.form.CardinalException;
import org.cristalise.gui.tabs.outcome.form.Dimension;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ElementDecl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataRecord
extends OutcomeStructure
implements ChangeListener {
    AttributeList myAttributes;
    JTabbedPane childDRTabs = null;
    boolean deferred;
    Document parentDoc;
    GridBagConstraints position;
    GridBagLayout gridbag;

    public DataRecord(ElementDecl model, boolean readOnly, boolean deferred, HashMap<String, Class<?>> specialEditFields) throws OutcomeException {
        super(model, readOnly, specialEditFields);
        this.deferred = deferred;
        if (!deferred) {
            this.setupPanel();
        }
    }

    public synchronized void activate() {
        this.deferred = false;
        try {
            this.setupPanel();
            if (this.myElement != null) {
                this.populateInstance();
            }
        }
        catch (OutcomeException ex) {
            this.removeAll();
            this.setLayout(new FlowLayout());
            this.add(new JLabel("Error displaying outcome segment: " + ex.getMessage()));
        }
        this.validate();
    }

    private void setupPanel() throws OutcomeException {
        ComplexType elementType;
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.position = new GridBagConstraints();
        this.position.anchor = 18;
        this.position.fill = 0;
        this.position.weightx = 1.0;
        this.position.weighty = 1.0;
        this.position.gridx = 0;
        this.position.gridy = 0;
        this.position.ipadx = 5;
        this.position.ipady = 5;
        this.position.insets = new Insets(5, 5, 0, 0);
        if (this.help != null) {
            this.position.fill = 1;
            this.add((Component)DataRecord.makeLabel(null, this.help), this.position);
            ++this.position.gridy;
        }
        this.myAttributes = new AttributeList(this.model, this.readOnly);
        this.position.gridwidth = 3;
        this.gridbag.setConstraints(this.myAttributes, this.position);
        this.add(this.myAttributes);
        try {
            elementType = (ComplexType)this.model.getType();
        }
        catch (ClassCastException e) {
            throw new StructuralException("DataRecord created with non-ComplexType");
        }
        try {
            this.enumerateElements((ContentModelGroup)elementType);
        }
        catch (OutcomeException e) {
            throw new OutcomeException("Element " + this.model.getName() + " could not be created: " + e.getMessage());
        }
    }

    @Override
    public void addStructure(OutcomeStructure newElement) throws OutcomeException {
        super.addStructure(newElement);
        if (newElement == null) {
            return;
        }
        if (newElement instanceof DataRecord) {
            DataRecord newRecord = (DataRecord)newElement;
            if (this.childDRTabs == null) {
                this.childDRTabs = new JTabbedPane();
                ++this.position.gridy;
                this.position.weightx = 1.0;
                this.position.fill = 2;
                this.position.gridwidth = 3;
                this.gridbag.setConstraints(this.childDRTabs, this.position);
                this.add(this.childDRTabs);
                this.deferChild = true;
            }
            this.childDRTabs.addTab(newRecord.getName(), newRecord);
            this.childDRTabs.addChangeListener(newRecord);
        } else {
            this.childDRTabs = null;
            this.deferChild = false;
            this.position.fill = 2;
            this.position.gridwidth = 3;
            this.position.weightx = 1.0;
            ++this.position.gridy;
            this.position.weighty = 1.0;
            this.gridbag.setConstraints(newElement, this.position);
            this.add(newElement);
        }
    }

    @Override
    public void addInstance(Element myElement, Document parentDoc) throws OutcomeException {
        Logger.msg((int)8, (String)("Accepting DR " + myElement.getTagName()));
        if (this.myElement != null) {
            throw new CardinalException("DataRecord " + this.getName() + " cannot repeat.");
        }
        this.myElement = myElement;
        this.parentDoc = parentDoc;
        if (!this.deferred) {
            this.populateInstance();
        }
    }

    public void populateInstance() throws OutcomeException {
        this.myAttributes.setInstance(this.myElement);
        NodeList childElements = this.myElement.getChildNodes();
        for (int i = 0; i < childElements.getLength(); ++i) {
            if (!(childElements.item(i) instanceof Element)) continue;
            Element thisElement = (Element)childElements.item(i);
            OutcomeStructure thisStructure = (OutcomeStructure)this.subStructure.get(thisElement.getTagName());
            if (thisStructure == null) {
                throw new StructuralException("DR " + this.model.getName() + " not expecting " + thisElement.getTagName());
            }
            thisStructure.addInstance(thisElement, this.parentDoc);
        }
        for (Object name2 : this.subStructure.keySet()) {
            String structureName = (String)name2;
            OutcomeStructure thisStructure = (OutcomeStructure)this.subStructure.get(structureName);
            int count = 0;
            if (thisStructure instanceof Dimension) {
                Dimension thisDimension = (Dimension)thisStructure;
                thisDimension.setParentElement(this.myElement);
                count = thisDimension.getChildCount();
            } else {
                count = thisStructure.getElement() == null ? 0 : 1;
            }
            int total = thisStructure.getModel().getMinOccurs();
            for (int i = count; i < total; ++i) {
                this.myElement.appendChild(thisStructure.initNew(this.parentDoc));
            }
        }
    }

    @Override
    public Element initNew(Document parent) {
        Logger.msg((int)6, (String)("Creating DR " + this.model.getName()));
        if (this.deferred) {
            this.activate();
        }
        this.myElement = parent.createElement(this.model.getName());
        for (Object name2 : this.order) {
            String structureName = (String)name2;
            OutcomeStructure thisStructure = (OutcomeStructure)this.subStructure.get(structureName);
            if (thisStructure instanceof Dimension) {
                ((Dimension)thisStructure).setParentElement(this.myElement);
            }
            for (int count = 0; count < thisStructure.getModel().getMinOccurs(); ++count) {
                this.myElement.appendChild(thisStructure.initNew(parent));
            }
        }
        this.myAttributes.initNew(this.myElement);
        return this.myElement;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane targetPane = (JTabbedPane)e.getSource();
        DataRecord targetTab = (DataRecord)targetPane.getSelectedComponent();
        if (targetTab == this && this.deferred) {
            SwingUtilities.invokeLater(new Thread(new Runnable(){

                @Override
                public void run() {
                    DataRecord.this.activate();
                }
            }));
        }
    }

    @Override
    public void grabFocus() {
        if (this.myAttributes.attrSet.size() > 0) {
            this.myAttributes.grabFocus();
        } else if (this.order.size() > 0) {
            ((OutcomeStructure)this.subStructure.get(this.order.get(0))).grabFocus();
        }
    }
}

