/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.form.CardinalException;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DimensionTableModel
extends AbstractTableModel {
    ElementDecl model;
    ArrayList<String> columnHeadings = new ArrayList();
    ArrayList<Class<?>> columnClasses = new ArrayList();
    ArrayList<Annotated> columnDecls = new ArrayList();
    ArrayList<Boolean> colReadOnly = new ArrayList();
    ArrayList<String> colHelp = new ArrayList();
    ArrayList<Object[]> rows = new ArrayList();
    ArrayList<Element> elements = new ArrayList();
    boolean readOnly;

    public DimensionTableModel(ElementDecl model, boolean readOnly) throws StructuralException {
        XMLType modelContent = model.getType();
        this.model = model;
        this.readOnly = readOnly;
        if (modelContent.isSimpleType()) {
            SimpleType elementType = (SimpleType)modelContent;
            SimpleType baseType = elementType.getBuiltInBaseType();
            this.addColumn(model.getName(), (Annotated)baseType, baseType.getTypeCode(), new Boolean(model.getFixedValue() != null));
        } else if (modelContent.isComplexType()) {
            XMLType baseType;
            ComplexType elementType = (ComplexType)modelContent;
            for (baseType = elementType.getBaseType(); !(baseType instanceof SimpleType) && baseType != null; baseType = baseType.getBaseType()) {
            }
            if (baseType != null) {
                int typeCode = ((SimpleType)baseType).getTypeCode();
                this.addColumn(model.getName(), (Annotated)baseType, typeCode, new Boolean(model.getFixedValue() != null));
            }
            Enumeration e = elementType.getAttributeDecls();
            while (e.hasMoreElements()) {
                AttributeDecl thisAttr = (AttributeDecl)e.nextElement();
                if (thisAttr.isReference()) {
                    thisAttr = thisAttr.getReference();
                }
                if (thisAttr.getSimpleType() == null) {
                    throw new StructuralException("Attribute " + thisAttr.getName() + " in " + model.getName() + " has no type");
                }
                this.addColumn(thisAttr.getName(), (Annotated)thisAttr, thisAttr.getSimpleType().getTypeCode(), new Boolean(thisAttr.isFixed()));
            }
            this.enumerateElements((ContentModelGroup)elementType);
        }
    }

    public synchronized void addColumn(String heading, Annotated decl, int typeCode, Boolean readOnly) {
        Logger.msg((int)8, (String)("Column " + heading + " contains " + decl.getClass().getName() + " readOnly=" + readOnly.toString()));
        this.columnHeadings.add(heading);
        this.columnDecls.add(decl);
        this.columnClasses.add(OutcomeStructure.getJavaClass(typeCode));
        this.colReadOnly.add(readOnly);
        String helpText = decl instanceof SimpleType ? OutcomeStructure.extractHelp((Annotated)this.model) : OutcomeStructure.extractHelp(decl);
        if (helpText.length() == 0) {
            helpText = "<i>No help is available for this cell</i>";
        }
        this.colHelp.add(helpText);
    }

    public void enumerateElements(ContentModelGroup group) throws StructuralException {
        Enumeration childElements = group.enumerate();
        while (childElements.hasMoreElements()) {
            Particle thisParticle = (Particle)childElements.nextElement();
            String extraHeader = "";
            if (thisParticle instanceof Group) {
                Group thisGroup = (Group)thisParticle;
                Order order = thisGroup.getOrder();
                if (order == Order.sequence || order == Order.all) {
                    this.enumerateElements((ContentModelGroup)thisGroup);
                    continue;
                }
                throw new StructuralException("Element " + thisGroup.getName() + ". Expecting sequence or all. Got " + thisGroup.getOrder());
            }
            if (thisParticle instanceof ElementDecl) {
                ElementDecl thisElement = (ElementDecl)thisParticle;
                int typeCode = -1;
                if (thisElement.getType() != null) {
                    if (thisElement.getType().isComplexType()) {
                        ComplexType elementType = (ComplexType)thisElement.getType();
                        if (elementType.getParticleCount() > 0 || thisElement.getMaxOccurs() > 1) {
                            throw new StructuralException("Too deep for a table");
                        }
                        Enumeration attrs = elementType.getAttributeDecls();
                        while (attrs.hasMoreElements()) {
                            AttributeDecl thisAttr = (AttributeDecl)attrs.nextElement();
                            if (!thisAttr.isFixed()) {
                                throw new StructuralException("Non-fixed attributes of child elements not supported in tables.");
                            }
                            extraHeader = extraHeader + " (" + thisAttr.getName() + ":" + (thisAttr.getFixedValue() != null ? thisAttr.getFixedValue() : thisAttr.getDefaultValue()) + ")";
                        }
                        XMLType parentType = thisElement.getType();
                        while (!(parentType instanceof SimpleType) && parentType != null) {
                            if ((parentType = parentType.getBaseType()) == null) continue;
                            typeCode = ((SimpleType)parentType).getTypeCode();
                        }
                    } else {
                        typeCode = ((SimpleType)thisElement.getType()).getTypeCode();
                    }
                }
                this.addColumn(thisElement.getName() + extraHeader, (Annotated)thisElement, typeCode, new Boolean(thisElement.getFixedValue() != null));
                continue;
            }
            throw new StructuralException("Particle " + thisParticle.getClass() + " not implemented");
        }
    }

    public void addInstance(Element myElement, int index) throws OutcomeException {
        if (index == -1) {
            index = this.elements.size();
        }
        Object[] newRow = new Object[this.columnHeadings.size()];
        for (int i = 0; i < this.columnDecls.size(); ++i) {
            if (this.columnDecls.get(i) instanceof ElementDecl) {
                ElementDecl thisElementDecl = (ElementDecl)this.columnDecls.get(i);
                NodeList childElements = myElement.getElementsByTagName(thisElementDecl.getName());
                switch (childElements.getLength()) {
                    case 1: {
                        Element childElement = (Element)childElements.item(0);
                        if (childElement.hasChildNodes()) {
                            Node thisNode = childElement.getFirstChild();
                            if (thisNode.getNodeType() == 3) {
                                newRow[i] = OutcomeStructure.getTypedValue(((Text)thisNode).getData(), this.columnClasses.get(i));
                                break;
                            }
                            throw new StructuralException("First child of Field " + thisElementDecl.getName() + " was not Text. (NodeType:" + thisNode.getNodeType() + ")");
                        }
                        newRow[i] = this.setupDefaultElement(thisElementDecl, childElement, this.columnClasses.get(i));
                        break;
                    }
                    case 0: {
                        Element newElement = myElement.getOwnerDocument().createElement(thisElementDecl.getName());
                        myElement.appendChild(newElement);
                        newRow[i] = this.setupDefaultElement(thisElementDecl, newElement, this.columnClasses.get(i));
                        break;
                    }
                    default: {
                        throw new CardinalException("Element " + thisElementDecl.getName() + " appeared more than once.");
                    }
                }
                continue;
            }
            if (this.columnDecls.get(i) instanceof AttributeDecl) {
                AttributeDecl thisAttrDecl = (AttributeDecl)this.columnDecls.get(i);
                newRow[i] = OutcomeStructure.getTypedValue(myElement.getAttribute(thisAttrDecl.getName()), this.columnClasses.get(i));
                continue;
            }
            Node thisNode = myElement.getFirstChild();
            if (thisNode == null) {
                thisNode = myElement.getOwnerDocument().createTextNode("");
                myElement.appendChild(thisNode);
            }
            if (thisNode.getNodeType() == 3 || thisNode.getNodeType() == 4) {
                newRow[i] = OutcomeStructure.getTypedValue(((Text)thisNode).getData(), this.columnClasses.get(i));
                continue;
            }
            throw new StructuralException("First child of Column " + myElement.getTagName() + " was not Text");
        }
        this.elements.add(index, myElement);
        this.rows.add(index, newRow);
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses.get(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnHeadings.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnHeadings.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean isReadOnly = this.readOnly || this.colReadOnly.get(columnIndex) != false;
        return !isReadOnly;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object[] thisRow = this.rows.get(rowIndex);
        thisRow[columnIndex] = aValue;
        Element myElement = this.elements.get(rowIndex);
        if (this.columnDecls.get(columnIndex) instanceof ElementDecl) {
            ElementDecl thisDecl = (ElementDecl)this.columnDecls.get(columnIndex);
            NodeList childElements = myElement.getElementsByTagName(thisDecl.getName());
            Text childNode = (Text)childElements.item(0).getFirstChild();
            childNode.setData(aValue.toString());
        } else if (this.columnDecls.get(columnIndex) instanceof AttributeDecl) {
            AttributeDecl thisDecl = (AttributeDecl)this.columnDecls.get(columnIndex);
            myElement.setAttribute(thisDecl.getName(), aValue.toString());
        } else {
            Text textNode = (Text)myElement.getFirstChild();
            textNode.setData(aValue.toString());
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public Element removeRow(int rowIndex) {
        Element elementToGo = this.elements.get(rowIndex);
        this.elements.remove(rowIndex);
        this.rows.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return elementToGo;
    }

    public Object setupDefaultElement(ElementDecl thisDecl, Element parent, Class<?> type) {
        String defaultValue = thisDecl.getFixedValue();
        if (defaultValue == null) {
            defaultValue = thisDecl.getDefaultValue();
        }
        Object newValue = this.readOnly ? "" : OutcomeStructure.getTypedValue(defaultValue, type);
        Text newNode = parent.getOwnerDocument().createTextNode(newValue.toString());
        parent.appendChild(newNode);
        try {
            ComplexType content = (ComplexType)thisDecl.getType();
            Enumeration attrs = content.getAttributeDecls();
            while (attrs.hasMoreElements()) {
                AttributeDecl thisAttr = (AttributeDecl)attrs.nextElement();
                parent.setAttribute(thisAttr.getName(), thisAttr.getFixedValue() != null ? thisAttr.getFixedValue() : thisAttr.getDefaultValue());
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        return newValue;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] thisRow = this.rows.get(rowIndex);
        if (!this.getColumnClass(columnIndex).equals(thisRow[columnIndex].getClass())) {
            Logger.warning((String)(thisRow[columnIndex] + " should be " + this.getColumnClass(columnIndex) + " is a " + thisRow[columnIndex].getClass().getName()));
        }
        return thisRow[columnIndex];
    }

    public String validateStructure() {
        for (int j = 0; j < this.rows.size(); ++j) {
            Object[] elems = this.rows.get(j);
            boolean empty = true;
            for (int i = 0; i < elems.length && empty; empty &= OutcomeStructure.isEmpty(elems[i]), ++i) {
            }
            if (!empty) continue;
            if (this.model.getMinOccurs() < this.rows.size()) {
                this.removeRow(j);
                continue;
            }
            return "Too many empty rows in table " + this.model.getName();
        }
        return null;
    }

    public Element initNew(Document parent, int index) {
        if (index == -1) {
            index = this.elements.size();
        }
        Object[] newRow = new Object[this.columnHeadings.size()];
        Element myElement = parent.createElement(this.model.getName());
        for (int i = 0; i < this.columnDecls.size(); ++i) {
            if (this.columnDecls.get(i) instanceof ElementDecl) {
                ElementDecl childElementDecl = (ElementDecl)this.columnDecls.get(i);
                Element childElement = parent.createElement(childElementDecl.getName());
                Object newValue = this.setupDefaultElement(childElementDecl, childElement, this.columnClasses.get(i));
                myElement.appendChild(childElement);
                newRow[i] = newValue;
                continue;
            }
            if (this.columnDecls.get(i) instanceof AttributeDecl) {
                AttributeDecl thisAttrDecl = (AttributeDecl)this.columnDecls.get(i);
                String newValue = thisAttrDecl.getFixedValue() != null ? thisAttrDecl.getFixedValue() : thisAttrDecl.getDefaultValue();
                newRow[i] = OutcomeStructure.getTypedValue(newValue, this.columnClasses.get(i));
                myElement.setAttribute(thisAttrDecl.getName(), newRow[i].toString());
                continue;
            }
            newRow[i] = this.setupDefaultElement(this.model, myElement, this.columnClasses.get(i));
        }
        this.elements.add(index, myElement);
        this.rows.add(index, newRow);
        this.fireTableRowsInserted(index, index);
        return myElement;
    }

    public String getHelp(int i) {
        return this.colHelp.get(i);
    }
}

