/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.cristalise.gui.tabs.outcome.form.OutcomePanel;
import org.cristalise.kernel.persistency.outcome.OutcomeValidator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

class OutcomeEditor
extends JFrame
implements ActionListener {
    boolean readOnly = false;
    File schemaFile = null;
    File instanceFile = null;
    JFileChooser chooser;
    OutcomePanel outcome;
    OutcomeValidator thisValid;

    public OutcomeEditor(File schema, File instance, boolean readOnly) {
        URL schemaURL = null;
        URL instanceURL = null;
        this.schemaFile = schema;
        this.instanceFile = instance;
        this.readOnly = readOnly;
        try {
            this.chooser = new JFileChooser();
            this.chooser.setCurrentDirectory(new File(new File(".").getCanonicalPath()));
        }
        catch (IOException e) {
            System.out.println("Could not initialise file dialog");
            System.exit(0);
        }
        this.setTitle("Outcome Editor");
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        if (this.schemaFile == null) {
            this.schemaFile = this.getFile("Choose Schema File", "xsd");
            if (this.schemaFile == null) {
                System.out.println("Cannot function without a schema");
                System.exit(1);
            }
        }
        try {
            schemaURL = this.schemaFile.toURI().toURL();
        }
        catch (Exception e) {
            System.out.println("Invalid schema URL");
            System.exit(1);
        }
        if (this.instanceFile == null) {
            this.instanceFile = this.getFile("Choose Instance File", "xml");
        }
        try {
            instanceURL = this.instanceFile.toURI().toURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.outcome = this.instanceFile != null && this.instanceFile.exists() ? new OutcomePanel(schemaURL, instanceURL, readOnly) : new OutcomePanel(schemaURL, readOnly);
            Schema thisSchema = new Schema(schemaURL.getFile(), -1, null, FileStringUtility.url2String((URL)schemaURL));
            this.thisValid = OutcomeValidator.getValidator((Schema)thisSchema);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.ipadx = 5;
        c.ipady = 5;
        gridbag.setConstraints(this.outcome, c);
        this.getContentPane().add(this.outcome);
        JButton saveButton = new JButton("Save");
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 1;
        gridbag.setConstraints(saveButton, c);
        this.getContentPane().add(saveButton);
        if (readOnly) {
            saveButton.setEnabled(false);
        }
        JButton saveAsButton = new JButton("Save As");
        saveAsButton.setActionCommand("saveas");
        saveAsButton.addActionListener(this);
        ++c.gridx;
        c.weighty = 0.0;
        gridbag.setConstraints(saveAsButton, c);
        this.getContentPane().add(saveAsButton);
        if (readOnly) {
            saveAsButton.setEnabled(false);
        }
        System.out.println("Building Outcome Panel. Please wait . . .");
        this.outcome.run();
        this.pack();
        this.setVisible(true);
    }

    public File getFile(String title, String fileType) {
        File targetFile = null;
        this.chooser.setFileFilter(new SimpleFilter(fileType));
        this.chooser.setDialogTitle(title);
        int returnVal = this.chooser.showDialog(this, "Select");
        if (returnVal == 0) {
            targetFile = this.chooser.getSelectedFile();
        }
        try {
            System.out.println(fileType + "=" + targetFile.toURI().toURL());
        }
        catch (Exception ex) {
            // empty catch block
        }
        return targetFile;
    }

    public static void usage() {
        System.out.println("-schema file:///schema.xsd");
        System.out.println("-inst file:///instance.xml");
        System.out.println("Leave one out to get a file open box.");
        System.exit(0);
    }

    public static void main(String[] argv) {
        Logger.addLogStream((PrintStream)System.out, (int)6);
        File instance = null;
        File schema = null;
        boolean readOnly = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-schema")) {
                schema = new File(argv[++i]);
            }
            if (argv[i].equals("-inst")) {
                instance = new File(argv[++i]);
            }
            if (argv[i].equals("-readOnly")) {
                readOnly = true;
            }
            if (!argv[i].equals("-help") && !argv[i].equals("-h")) continue;
            OutcomeEditor.usage();
        }
        new OutcomeEditor(schema, instance, readOnly);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().indexOf("save") == 0) {
            int choice;
            String output = this.outcome.getOutcome();
            String errors = this.thisValid.validate(output);
            if (errors != null && errors.length() > 0 && (choice = JOptionPane.showConfirmDialog(null, errors + "\n\nSave anyway?", "Errors validating document", 0)) != 0) {
                return;
            }
            if (this.instanceFile == null || e.getActionCommand().equals("saveas")) {
                this.instanceFile = this.getFile("Choose Instance File", "xml");
                if (this.instanceFile == null) {
                    System.out.println(output);
                    return;
                }
            }
            try {
                FileOutputStream targetStream = new FileOutputStream(this.instanceFile);
                targetStream.write(output.getBytes());
                targetStream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class SimpleFilter
    extends FileFilter {
        String extension;

        public SimpleFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public String getDescription() {
            return this.extension.toUpperCase() + " Files";
        }

        @Override
        public boolean accept(File f) {
            return f.isFile() && f.getName().endsWith(this.extension.toLowerCase()) || f.isDirectory();
        }
    }
}

