/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cristalise.gui.tabs.outcome.InvalidOutcomeException;
import org.cristalise.gui.tabs.outcome.InvalidSchemaException;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.OutcomeHandler;
import org.cristalise.gui.tabs.outcome.OutcomeNotInitialisedException;
import org.cristalise.gui.tabs.outcome.form.DataRecord;
import org.cristalise.gui.tabs.outcome.form.Field;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OutcomePanel
extends JPanel
implements OutcomeHandler {
    Schema schemaSOM;
    Document outcomeDOM;
    OutcomeStructure documentRoot;
    DocumentBuilder parser;
    boolean readOnly;
    boolean useForm = true;
    boolean panelBuilt = false;
    boolean unsaved = false;
    JScrollPane scrollpane = new JScrollPane();
    protected HashMap<String, Class<?>> specialEditFields = new HashMap();
    JTextArea basicView;

    public OutcomePanel() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(false);
        try {
            this.parser = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipadx = 5;
        c.ipady = 5;
        gridbag.setConstraints(this.scrollpane, c);
        this.add(this.scrollpane);
    }

    public OutcomePanel(boolean readOnly) {
        this();
        this.setReadOnly(readOnly);
    }

    public OutcomePanel(String schema, boolean readOnly) throws OutcomeException {
        this(readOnly);
        this.setDescription(schema);
    }

    public OutcomePanel(String schema, String outcome, boolean readOnly) throws OutcomeException {
        this(readOnly);
        this.setDescription(schema);
        this.setOutcome(outcome);
    }

    public void setOutcome(URL outcomeURL) throws InvalidOutcomeException {
        try {
            this.setOutcome(new InputSource(outcomeURL.openStream()));
        }
        catch (IOException ex) {
            throw new InvalidOutcomeException("Error creating instance DOM tree: " + ex);
        }
    }

    public void setDescription(URL schemaURL) throws InvalidSchemaException {
        Logger.msg((int)7, (String)("OutcomePanel.setDescription() - schemaURL:" + schemaURL.toString()));
        try {
            this.setDescription(new InputSource(schemaURL.openStream()));
        }
        catch (IOException ex) {
            throw new InvalidSchemaException("Error creating exolab schema object: " + ex);
        }
    }

    public OutcomePanel(URL schemaURL, boolean readOnly) throws OutcomeException {
        this(readOnly);
        this.setDescription(schemaURL);
    }

    public OutcomePanel(URL schemaURL, URL outcomeURL, boolean readOnly) throws OutcomeException {
        this(readOnly);
        this.setDescription(schemaURL);
        this.setOutcome(outcomeURL);
    }

    @Override
    public void setOutcome(String outcome) throws InvalidOutcomeException {
        try {
            this.setOutcome(new InputSource(new StringReader(outcome)));
        }
        catch (IOException ex) {
            throw new InvalidOutcomeException("Error creating instance DOM tree: " + ex);
        }
    }

    @Override
    public void setDescription(String schema) throws InvalidSchemaException {
        if (schema == null) {
            throw new InvalidSchemaException("Null schema supplied");
        }
        try {
            this.setDescription(new InputSource(new StringReader(schema)));
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setDescription(InputSource schemaSource) throws InvalidSchemaException, IOException {
        SchemaReader mySchemaReader = new SchemaReader(schemaSource);
        this.schemaSOM = mySchemaReader.read();
    }

    public void setOutcome(InputSource outcomeSource) throws InvalidOutcomeException, IOException {
        try {
            this.outcomeDOM = this.parser.parse(outcomeSource);
        }
        catch (SAXException ex) {
            throw new InvalidOutcomeException("Sax error parsing Outcome " + ex);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Outcome Panel Builder");
        try {
            this.makeDisplay();
        }
        catch (Exception oe) {
            this.scrollpane.setViewportView(new JLabel("Outcome View Generation Failed: " + oe.getMessage()));
            Logger.error((Throwable)oe);
        }
    }

    public void makeDisplay() {
        try {
            this.initPanel();
        }
        catch (OutcomeException ex) {
            this.useForm = false;
            Box textPanel = Box.createVerticalBox();
            JLabel errorMsg = new JLabel("Could not create outcome view: " + ex.getMessage());
            errorMsg.setHorizontalAlignment(2);
            textPanel.add(errorMsg);
            textPanel.add(Box.createVerticalGlue());
            if (this.outcomeDOM != null) {
                String xml = "";
                try {
                    xml = Outcome.serialize((Document)this.outcomeDOM, (boolean)true);
                }
                catch (InvalidDataException e) {
                    // empty catch block
                }
                this.basicView = new JTextArea(xml);
                this.basicView.setEnabled(!this.readOnly);
                textPanel.add(this.basicView);
            }
            this.scrollpane.setViewportView(textPanel);
        }
    }

    public void initPanel() throws OutcomeException {
        Logger.msg((int)5, (String)"Initialising Panel..");
        this.scrollpane.setViewportView(new JLabel("Building outcome. Please hang on two ticks . . ."));
        if (this.schemaSOM == null) {
            throw new InvalidSchemaException("A valid schema has not been supplied.");
        }
        ElementDecl rootElementDecl = null;
        Element docElement = this.outcomeDOM == null ? null : this.outcomeDOM.getDocumentElement();
        HashMap<String, ElementDecl> foundRoots = new HashMap<String, ElementDecl>();
        for (ElementDecl elementDecl : this.schemaSOM.getElementDecls()) {
            foundRoots.put(elementDecl.getName(), elementDecl);
        }
        if (foundRoots.size() == 0) {
            throw new InvalidSchemaException("No root elements defined");
        }
        if (foundRoots.size() == 1) {
            rootElementDecl = (ElementDecl)foundRoots.values().iterator().next();
        } else if (docElement != null) {
            rootElementDecl = (ElementDecl)foundRoots.get(docElement.getTagName());
        } else {
            Object[] rootArr = foundRoots.keySet().toArray(new String[0]);
            String choice = (String)JOptionPane.showInputDialog(this, "Choose the root element:", "Multiple possible root elements found", -1, null, rootArr, rootArr[0]);
            rootElementDecl = (ElementDecl)foundRoots.get(choice);
        }
        if (rootElementDecl == null) {
            throw new InvalidSchemaException("No root elements defined");
        }
        this.documentRoot = rootElementDecl.getType().isSimpleType() || ((ComplexType)rootElementDecl.getType()).isSimpleContent() ? new Field(rootElementDecl, this.readOnly, this.specialEditFields) : new DataRecord(rootElementDecl, this.readOnly, false, this.specialEditFields);
        Logger.msg((int)5, (String)"Finished structure. Populating...");
        if (docElement == null) {
            this.outcomeDOM = this.parser.newDocument();
            docElement = this.documentRoot.initNew(this.outcomeDOM);
            this.outcomeDOM.appendChild(docElement);
        } else {
            this.documentRoot.addInstance(docElement, this.outcomeDOM);
        }
        JTabbedPane outcomeTab = new JTabbedPane();
        outcomeTab.addTab(rootElementDecl.getName(), this.documentRoot);
        outcomeTab.setSelectedIndex(0);
        this.scrollpane.setViewportView(outcomeTab);
        this.panelBuilt = true;
        this.revalidate();
        this.doLayout();
        if (!this.readOnly) {
            this.documentRoot.grabFocus();
        }
    }

    @Override
    public JPanel getPanel() throws OutcomeNotInitialisedException {
        return this;
    }

    @Override
    public String getOutcome() {
        if (this.useForm) {
            this.documentRoot.validateStructure();
            try {
                return Outcome.serialize((Document)this.outcomeDOM, (boolean)false);
            }
            catch (InvalidDataException invalidDataException) {
                return "";
            }
        }
        return this.basicView.getText();
    }

    @Override
    public boolean isUnsaved() {
        return this.unsaved;
    }

    @Override
    public void saved() {
        this.unsaved = false;
    }

    @Override
    public void export(File targetFile) throws Exception {
        FileStringUtility.string2File((File)targetFile, (String)this.getOutcome());
    }
}

