/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tree;

import java.util.Iterator;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.tree.Node;
import org.cristalise.kernel.entity.proxy.DomainPathSubscriber;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class NodeContext
extends Node
implements DomainPathSubscriber {
    Iterator<Path> children;

    public NodeContext(Path path, ItemTabManager desktop) {
        super(path, desktop);
        this.itemPath = null;
        this.createTreeNode();
        this.makeExpandable();
        this.type = "Cristal Context";
    }

    @Override
    public void loadChildren() {
        Path newPath;
        if (this.children == null) {
            if (this.binding instanceof DomainPath) {
                Gateway.getProxyManager().subscribeTree((DomainPathSubscriber)this, (DomainPath)this.binding);
            }
            this.children = Gateway.getLookup().getChildren(this.binding);
        }
        for (int batch = 75; this.children.hasNext() && batch > 0 && (newPath = this.children.next()) != null; --batch) {
            Logger.msg((int)2, (String)("Subscription.run() - new node: " + newPath));
            this.add(this.newNode(newPath));
        }
        this.end(this.children.hasNext());
    }

    public void pathAdded(DomainPath path) {
        this.add(this.newNode((Path)path));
    }

    @Override
    public void refresh() {
        this.children = null;
        super.refresh();
    }

    public void pathRemoved(DomainPath path) {
        this.remove((Path)path);
    }
}

