/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.desc;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.cristalise.gui.graph.view.VertexRenderer;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.AndSplitDef;
import org.cristalise.kernel.lifecycle.JoinDef;
import org.cristalise.kernel.lifecycle.LoopDef;
import org.cristalise.kernel.lifecycle.OrSplitDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.XOrSplitDef;

public class SplitJoinDefRenderer
implements VertexRenderer {
    private Paint mTextPaint = Color.black;
    private Paint mBoxPaint = new Color(204, 204, 204);
    private Paint mErrorPaint = new Color(255, 50, 0);
    private boolean mTextOffsetsNotInitialised = true;
    private int mTextYOffset = 0;
    private String mAndText = "And";
    private int mAndTextXOffset = 0;
    private String mOrText = "Or";
    private int mOrTextXOffset = 0;
    private String mXOrText = "XOr";
    private int mXOrTextXOffset = 0;
    private String mJoinText = "Join";
    private int mJoinTextXOffset = 0;
    private String mLoopText = "Loop";
    private int mLoopTextXOffset = 0;
    private String mRouteText = "";
    private int mRouteTextXOffset = 0;
    private String mXXXText = "XXX";
    private int mXXXTextXOffset = 0;

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        boolean hasError;
        GraphPoint centrePoint = vertex.getCentrePoint();
        String text = null;
        int textXOffset = 0;
        int vertexHeight = vertex.getHeight();
        int vertexWidth = vertex.getWidth();
        boolean bl = hasError = !((WfVertexDef)vertex).verify();
        if (this.mTextOffsetsNotInitialised) {
            this.initialiseTextOffsets(g2d);
            this.mTextOffsetsNotInitialised = false;
        }
        if (vertex instanceof LoopDef) {
            text = this.mLoopText;
            textXOffset = this.mLoopTextXOffset;
        } else if (vertex instanceof XOrSplitDef) {
            text = this.mXOrText;
            textXOffset = this.mXOrTextXOffset;
        } else if (vertex instanceof OrSplitDef) {
            text = this.mOrText;
            textXOffset = this.mOrTextXOffset;
        } else if (vertex instanceof AndSplitDef) {
            text = this.mAndText;
            textXOffset = this.mAndTextXOffset;
        } else if (vertex instanceof JoinDef) {
            String type = (String)((JoinDef)vertex).getProperties().get((Object)"Type");
            if (type != null && type.equals("Route")) {
                text = this.mRouteText;
                textXOffset = this.mRouteTextXOffset;
            } else {
                text = this.mJoinText;
                textXOffset = this.mJoinTextXOffset;
            }
        } else {
            text = this.mXXXText;
            textXOffset = this.mXXXTextXOffset;
        }
        g2d.setPaint(hasError ? this.mErrorPaint : this.mBoxPaint);
        g2d.fillRect(centrePoint.x - vertexWidth / 2, centrePoint.y - vertexHeight / 2, vertexWidth, vertexHeight);
        g2d.setPaint(this.mTextPaint);
        g2d.drawRect(centrePoint.x - vertexWidth / 2, centrePoint.y - vertexHeight / 2, vertexWidth, vertexHeight);
        g2d.drawString(text, centrePoint.x - textXOffset, centrePoint.y + this.mTextYOffset);
        if (hasError) {
            g2d.setPaint(this.mErrorPaint);
            String errors = ((WfVertexDef)vertex).getErrors();
            int errorWidth = g2d.getFontMetrics().stringWidth(errors);
            g2d.drawString(errors, centrePoint.x - errorWidth / 2, centrePoint.y + vertexHeight);
        }
    }

    private void initialiseTextOffsets(Graphics2D g2d) {
        FontMetrics metrics = g2d.getFontMetrics();
        this.mTextYOffset = metrics.getHeight() / 3;
        this.mAndTextXOffset = metrics.stringWidth(this.mAndText) / 2;
        this.mOrTextXOffset = metrics.stringWidth(this.mOrText) / 2;
        this.mXOrTextXOffset = metrics.stringWidth(this.mXOrText) / 2;
        this.mJoinTextXOffset = metrics.stringWidth(this.mJoinText) / 2;
        this.mLoopTextXOffset = metrics.stringWidth(this.mJoinText) / 2;
        this.mRouteTextXOffset = metrics.stringWidth(this.mRouteText) / 2;
    }
}

