/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tree;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.Logger;

public class NodeCollection
extends Node
implements ProxyObserver<Collection<? extends CollectionMember>> {
    ItemProxy parent;
    Collection<? extends CollectionMember> thisCollection;
    String path;

    public NodeCollection(ItemProxy parent, String name, ItemTabManager desktop) {
        super(desktop);
        this.parent = parent;
        this.name = name;
        this.path = parent.getPath() + "/" + ClusterStorage.COLLECTION + "/" + name + "/last";
        this.createTreeNode();
        this.makeExpandable();
    }

    public NodeCollection(ItemProxy parent, Collection<? extends CollectionMember> coll, ItemTabManager desktop) {
        super(desktop);
        this.parent = parent;
        this.name = coll.getName();
        this.path = parent.getPath() + "/" + ClusterStorage.COLLECTION + "/" + this.name + "/last";
        this.createTreeNode();
        this.makeExpandable();
        this.add(coll);
    }

    @Override
    public void loadChildren() {
        Logger.msg((int)8, (String)"NodeCollection::loadChildren()", (Object[])new Object[0]);
        try {
            if (this.thisCollection == null) {
                Collection initColl = (Collection)this.parent.getObject(ClusterStorage.COLLECTION + "/" + this.name + "/last");
                this.add((Collection<? extends CollectionMember>)initColl);
            }
            this.parent.subscribe(new MemberSubscription((ProxyObserver)this, ClusterStorage.COLLECTION, false));
        }
        catch (ObjectNotFoundException ex) {
            this.end(false);
            return;
        }
    }

    public void add(Collection<? extends CollectionMember> contents) {
        if (!contents.getName().equals(this.name)) {
            return;
        }
        this.type = contents.getClass().getSimpleName();
        ArrayList newMembers = contents.getMembers().list;
        ArrayList oldMembers = this.thisCollection == null ? new ArrayList() : this.thisCollection.getMembers().list;
        ArrayList<ItemPath> currentPaths = new ArrayList<ItemPath>();
        for (CollectionMember newMember : newMembers) {
            ItemPath itemPath = newMember.getItemPath();
            if (oldMembers.contains(newMember) || itemPath == null) continue;
            currentPaths.add(itemPath);
            NodeItem newMemberNode = new NodeItem((Path)itemPath, this.desktop);
            newMemberNode.setCollection(contents, newMember.getID(), this.parent);
            newMemberNode.setToolTip(NodeCollection.getPropertyToolTip(newMember.getProperties()));
            this.add(newMemberNode);
        }
        for (Path childPath : this.childNodes.keySet()) {
            if (currentPaths.contains(childPath)) continue;
            this.remove(childPath);
        }
        this.thisCollection = contents;
        if (this.isDependency()) {
            this.setToolTip(NodeCollection.getPropertyToolTip(((Dependency)contents).getProperties()));
        }
        this.end(false);
    }

    public boolean addMember(ItemPath itemPath) {
        if (!this.isDependency()) {
            return false;
        }
        String[] params = new String[]{this.thisCollection.getName(), itemPath.getUUID().toString()};
        try {
            MainFrame.userAgent.execute(this.parent, "AddMemberToCollection", params);
            return true;
        }
        catch (Exception e1) {
            MainFrame.exceptionDialog(e1);
            return false;
        }
    }

    public static String getPropertyToolTip(CastorHashMap props) {
        if (props.size() == 0) {
            return null;
        }
        StringBuffer verStr = new StringBuffer("<html>");
        for (KeyValuePair prop : props.getKeyValuePairs()) {
            verStr.append("<b>").append(prop.getKey()).append(":</b> ").append(prop.getValue()).append("<br/>");
        }
        return verStr.append("</html>").toString();
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    public void remove(String id) {
    }

    public void control(String control, String msg) {
    }

    public boolean isDependency() {
        return this.thisCollection instanceof Dependency;
    }
}

