/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.controller;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.cristalise.gui.graph.view.EditorModeListener;
import org.cristalise.gui.graph.view.EditorToolBar;
import org.cristalise.gui.graph.view.GraphPanel;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;

public class EdgeConstructionController
extends MouseAdapter
implements EditorModeListener {
    private GraphModelManager mGraphModelManager = null;
    private GraphPanel mGraphPanel = null;
    private EditorToolBar mEditorToolBar = null;
    private final Integer kOtherMode = new Integer(0);
    private final Integer kWaitOrigin = new Integer(1);
    private final Integer kWaitTerminus = new Integer(2);
    private final int kEdgeEntered = 0;
    private final int kOtherEntered = 1;
    private final int kPressOnVertex = 2;
    private final int kDrag = 3;
    private final int kReleaseOnTerminus = 4;
    private final int kReleaseOnNothing = 5;
    private Action mSetOriginVertex = new Action(){

        @Override
        public void doIt(Object data) {
            if (EdgeConstructionController.this.mGraphModelManager != null) {
                EdgeConstructionController.this.mGraphModelManager.getModel().setNewEdgeOriginVertex((Vertex)data);
            }
        }
    };
    private Action mSetEndPoint = new Action(){

        @Override
        public void doIt(Object data) {
            if (EdgeConstructionController.this.mGraphModelManager != null) {
                Point mouse = (Point)data;
                EdgeConstructionController.this.mGraphModelManager.getModel().setNewEdgeEndPoint(new GraphPoint(mouse.x, mouse.y));
            }
        }
    };
    private Action mClearEdge = new Action(){

        @Override
        public void doIt(Object data) {
            if (EdgeConstructionController.this.mGraphModelManager != null) {
                EdgeConstructionController.this.mGraphModelManager.getModel().setNewEdgeOriginVertex(null);
                EdgeConstructionController.this.mGraphModelManager.getModel().setNewEdgeEndPoint(null);
            }
        }
    };
    private Action mCreateEdge = new Action(){

        @Override
        public void doIt(Object data) {
            if (EdgeConstructionController.this.mGraphModelManager != null && EdgeConstructionController.this.mEditorToolBar != null && EdgeConstructionController.this.mGraphModelManager.isEditable()) {
                EdgeConstructionController.this.mGraphModelManager.getModel().createDirectedEdge(EdgeConstructionController.this.mGraphModelManager.getModel().getNewEdgeOriginVertex(), (Vertex)data, EdgeConstructionController.this.mEditorToolBar.getSelectedEdgeType());
                EdgeConstructionController.this.mGraphModelManager.getModel().setNewEdgeOriginVertex(null);
                EdgeConstructionController.this.mGraphModelManager.getModel().setNewEdgeEndPoint(null);
            }
        }
    };
    private Object[][][] mFSTN = new Object[][][]{{{null, this.kWaitOrigin}, null, null}, {null, {null, this.kOtherMode}, null}, {null, {this.mSetOriginVertex, this.kWaitTerminus}, null}, {null, null, {this.mSetEndPoint, null}}, {null, null, {this.mCreateEdge, this.kWaitOrigin}}, {null, null, {this.mClearEdge, this.kWaitOrigin}}};
    private Integer mState = this.kOtherMode;

    private void processEvent(int event, Object data) {
        Object[] transition = this.mFSTN[event][this.mState];
        Action action = null;
        Integer nextState = null;
        if (transition != null) {
            action = (Action)transition[0];
            nextState = (Integer)transition[1];
            if (action != null) {
                action.doIt(data);
            }
            if (nextState != null) {
                this.mState = nextState;
            }
        }
    }

    public void setGraphModelManager(GraphModelManager graphModelManager) {
        this.mGraphModelManager = graphModelManager;
    }

    public void setGraphPanel(GraphPanel graphPanel) {
        this.mGraphPanel = graphPanel;
    }

    public void setEditorToolBar(EditorToolBar editorToolBar) {
        this.mEditorToolBar = editorToolBar;
        this.mEditorToolBar.addEditorModeListener(this);
    }

    @Override
    public void editorModeChanged(String idOfNewMode) {
        if (idOfNewMode.equals("Edge")) {
            this.processEvent(0, null);
        } else {
            this.processEvent(1, null);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Vertex vertex = null;
        Point mousePoint = null;
        if (this.mGraphModelManager != null && this.mGraphPanel != null) {
            mousePoint = me.getPoint();
            vertex = this.mGraphPanel.getVertex(new GraphPoint(mousePoint.x, mousePoint.y));
            if (vertex != null) {
                this.processEvent(2, vertex);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        Vertex vertex = null;
        Point mousePoint = null;
        if (this.mGraphModelManager != null && this.mGraphPanel != null) {
            mousePoint = me.getPoint();
            vertex = this.mGraphPanel.getVertex(new GraphPoint(mousePoint.x, mousePoint.y));
            if (vertex != null && vertex != this.mGraphModelManager.getModel().getNewEdgeOriginVertex()) {
                this.processEvent(4, vertex);
            } else {
                this.processEvent(5, null);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.processEvent(3, me.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    private static interface Action {
        public void doIt(Object var1);
    }
}

