/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import org.cristalise.gui.graph.event.SelectionChangedEvent;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.Vertex;

public class StartVertexController
implements Observer,
ActionListener {
    private GraphModelManager mGraphModelManager = null;
    private JButton mStartButton = null;
    private Vertex selectedVertex = null;

    public void setGraphModelManager(GraphModelManager graphModelManager) {
        this.mGraphModelManager = graphModelManager;
        this.mGraphModelManager.addObserver((Observer)this);
    }

    public void setStartButton(JButton startButton) {
        this.mStartButton = startButton;
        this.mStartButton.addActionListener(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        SelectionChangedEvent event = null;
        Vertex[] selectedVertices = null;
        if (arg instanceof SelectionChangedEvent && this.mStartButton != null) {
            event = (SelectionChangedEvent)((Object)arg);
            selectedVertices = event.mSelection.mVertices;
            if (selectedVertices == null || selectedVertices.length != 1) {
                this.mStartButton.setEnabled(false);
            } else if (this.mGraphModelManager.isEditable()) {
                this.mStartButton.setEnabled(true);
                this.selectedVertex = selectedVertices[0];
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.selectedVertex != null) {
            this.mGraphModelManager.getModel().setStartVertexId(this.selectedVertex.getID());
        }
    }
}

