/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.view;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.cristalise.gui.graph.view.DirectedEdgeRenderer;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphPoint;

public class DefaultDirectedEdgeRenderer
implements DirectedEdgeRenderer {
    private GeneralPath mArrowTemplate = new GeneralPath();
    private Paint mLinePaint = null;

    public DefaultDirectedEdgeRenderer(Paint linePaint) {
        this.mLinePaint = linePaint;
        this.mArrowTemplate.moveTo(-5.0f, 5.0f);
        this.mArrowTemplate.lineTo(0.0f, 0.0f);
        this.mArrowTemplate.lineTo(5.0f, 5.0f);
    }

    @Override
    public void draw(Graphics2D g2d, DirectedEdge directedEdge) {
        GraphPoint originPoint = directedEdge.getOriginPoint();
        GraphPoint terminusPoint = directedEdge.getTerminusPoint();
        GraphPoint midPoint = new GraphPoint();
        AffineTransform transform = new AffineTransform();
        Shape arrow = null;
        g2d.setPaint(this.mLinePaint);
        g2d.drawLine(originPoint.x, originPoint.y, terminusPoint.x, terminusPoint.y);
        midPoint.x = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
        midPoint.y = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
        transform.translate(midPoint.x, midPoint.y);
        transform.rotate(DefaultDirectedEdgeRenderer.calcArrowAngle(originPoint.x, originPoint.y, terminusPoint.x, terminusPoint.y));
        arrow = this.mArrowTemplate.createTransformedShape(transform);
        g2d.draw(arrow);
    }

    private static double calcArrowAngle(int originX, int originY, int terminusX, int terminusY) {
        double width = terminusX - originX;
        double height = terminusY - originY;
        if (width == 0.0 && height > 0.0) {
            return Math.PI;
        }
        if (width == 0.0 && height < 0.0) {
            return 0.0;
        }
        if (width > 0.0 && height == 0.0) {
            return 1.5707963267948966;
        }
        if (width < 0.0 && height == 0.0) {
            return -1.5707963267948966;
        }
        if (width > 0.0 && height > 0.0) {
            return 1.5707963267948966 + Math.atan(Math.abs(height) / Math.abs(width));
        }
        if (width > 0.0 && height < 0.0) {
            return Math.atan(Math.abs(width) / Math.abs(height));
        }
        if (width < 0.0 && height < 0.0) {
            return -1.0 * Math.atan(Math.abs(width) / Math.abs(height));
        }
        if (width < 0.0 && height > 0.0) {
            return -1.0 * (1.5707963267948966 + Math.atan(Math.abs(height) / Math.abs(width)));
        }
        return 0.0;
    }
}

