/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.awt.Toolkit;
import java.math.BigDecimal;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.cristalise.gui.tabs.outcome.form.field.EditField;

public class DecimalEditField
extends EditField {
    public DecimalEditField() {
        this.field.addFocusListener(this);
        this.field.setToolTipText("This field must contains a decimal number e.g. 3.14159265");
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    @Override
    public void setText(String text) {
        this.field.setText(text);
    }

    @Override
    public String getDefaultValue() {
        return "0.0";
    }

    @Override
    public JTextComponent makeTextField() {
        return new DecimalTextField();
    }

    private class Decimal
    extends PlainDocument {
        private Decimal() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.equals("")) {
                return;
            }
            String proposedResult = null;
            if (this.getLength() == 0) {
                proposedResult = str;
            } else {
                StringBuffer currentBuffer = new StringBuffer(this.getText(0, this.getLength()));
                currentBuffer.insert(offs, str);
                proposedResult = currentBuffer.toString();
            }
            try {
                this.parse(proposedResult);
                super.insertString(offs, str, a);
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(len + offs, currentText.length());
            String proposedResult = beforeOffset + afterOffset;
            if (proposedResult.length() == 0) {
                super.remove(offs, len);
                return;
            }
            try {
                this.parse(proposedResult);
                super.remove(offs, len);
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public BigDecimal parse(String proposedResult) throws NumberFormatException {
            BigDecimal value = new BigDecimal(0);
            if (proposedResult.length() != 0) {
                value = new BigDecimal(proposedResult);
            }
            return value;
        }
    }

    private class DecimalTextField
    extends JTextField {
        public DecimalTextField() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected Document createDefaultModel() {
            return new Decimal();
        }
    }
}

