/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.cristalise.gui.Console;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class MenuBuilder
extends JMenuBar
implements ActionListener,
ItemListener,
HyperlinkListener {
    protected UIManager.LookAndFeelInfo[] availableViews = UIManager.getInstalledLookAndFeels();
    protected MainFrame myParentFrame;
    protected JMenu fileMenu;
    protected JMenu consoleMenu;
    protected JMenu styleMenu;
    protected JMenu prefMenu;
    protected JMenu helpMenu;
    protected HashMap<String, JMenu> availableMenus = new HashMap();

    public MenuBuilder() {
    }

    public MenuBuilder(MainFrame parentFrame) {
        this.myParentFrame = parentFrame;
        this.fileMenu = new JMenu("File");
        this.consoleMenu = new JMenu("Console");
        this.styleMenu = new JMenu("Style");
        this.prefMenu = new JMenu("Preferences");
        this.helpMenu = new JMenu("Help");
        this.availableMenus.put("file", this.fileMenu);
        this.availableMenus.put("console", this.consoleMenu);
        this.availableMenus.put("preferences", this.prefMenu);
        this.availableMenus.put("style", this.styleMenu);
        this.availableMenus.put("help", this.helpMenu);
        this.addMenuItem("Close All", "file", null, 0);
        this.addMenuItem("Close Others", "file", null, 0);
        this.fileMenu.insertSeparator(2);
        this.addMenuItem("Exit", "file", null, 0);
        this.addMenuItem("Local console", "console", null, 0);
        this.consoleMenu.insertSeparator(5);
        this.addServerConsoles();
        ButtonGroup styleButtonGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo availableView : this.availableViews) {
            this.addMenuItem(availableView.getName(), "style", styleButtonGroup, 0);
        }
        this.addMenuItem("Tree Browser", "preferences", null, MainFrame.getPref("ShowTree", "true").equals("true") ? 2 : 1);
        this.addMenuItem("Graph Properties", "preferences", null, MainFrame.getPref("ShowProps", "true").equals("true") ? 2 : 1);
        this.addMenuItem("About", "help", null, 0);
        this.add(this.fileMenu);
        this.add(this.consoleMenu);
        this.add(this.styleMenu);
        this.add(this.prefMenu);
        this.add(this.helpMenu);
    }

    private void addServerConsoles() {
        Iterator servers = Gateway.getLookup().search((Path)new DomainPath("/servers"), new Property[]{new Property("Type", "Server", false)});
        while (servers.hasNext()) {
            Path thisServerPath = (Path)servers.next();
            try {
                ItemPath serverItemPath = thisServerPath.getItemPath();
                String serverName = ((Property)Gateway.getStorage().get(serverItemPath, ClusterStorage.PROPERTY + "/Name", null)).getValue();
                String portStr = ((Property)Gateway.getStorage().get(serverItemPath, ClusterStorage.PROPERTY + "/ConsolePort", null)).getValue();
                this.addMenuItem(serverName + ":" + portStr, "console", null, 0);
            }
            catch (Exception ex) {
                Logger.error((String)("Exception retrieving proxy server connection data for " + thisServerPath), (Object[])new Object[0]);
                Logger.error((Throwable)ex);
            }
        }
    }

    public void addMenuItem(String itemName, String menuName, ButtonGroup bg, int checkBox) {
        if (this.availableMenus.containsKey(menuName)) {
            JMenuItem myItem = new JMenuItem(itemName);
            if (bg != null) {
                myItem = new JRadioButtonMenuItem(itemName, UIManager.getLookAndFeel().getName().equals(itemName));
                bg.add(myItem);
            }
            if (checkBox != 0) {
                myItem = new JCheckBoxMenuItem(itemName, checkBox == 2);
            }
            myItem.addActionListener(this);
            JMenu myMenu = this.availableMenus.get(menuName);
            myMenu.add(myItem);
        }
    }

    public int isStyleChange(String style) {
        for (int i = 0; i < this.availableViews.length; ++i) {
            if (!style.equals(this.availableViews[i].getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        int i = this.isStyleChange(s);
        if (s.equals("Close All") || s.equals("Close Others")) {
            MainFrame.myDesktopManager.closeAll(s.equals("Close Others"));
        } else if (s.equals("Exit")) {
            this.myParentFrame.exitForm();
        } else if (s.equals("About")) {
            this.showAboutWindow();
        } else if (i >= 0) {
            try {
                UIManager.setLookAndFeel(this.availableViews[i].getClassName());
                SwingUtilities.updateComponentTreeUI(this.myParentFrame);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (s.equals("Tree Browser")) {
            this.myParentFrame.toggleTree();
        } else if (s.indexOf(":") > 0) {
            try {
                String[] serverDetails = s.split(":");
                new Console(serverDetails[0], Integer.parseInt(serverDetails[1])).setVisible(true);
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
            }
        } else if (s.equals("Local console")) {
            try {
                new Console("localhost", Logger.getConsolePort()).setVisible(true);
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
            }
        } else if (s.equals("Graph Properties")) {
            MainFrame.setPref("ShowProps", String.valueOf(!MainFrame.getPref("ShowProps", "true").equals("true")));
        } else {
            Logger.msg((int)1, (String)"MenuBuilder.actionPerformed() - No action associated with the event received", (Object[])new Object[0]);
        }
    }

    public void showAboutWindow() {
        String aboutInfo;
        JOptionPane myPane = new JOptionPane();
        Box about = Box.createVerticalBox();
        try {
            aboutInfo = FileStringUtility.file2String((String)Gateway.getProperties().getString("about"));
        }
        catch (Exception e) {
            aboutInfo = "CRISTAL Item Browser";
        }
        JLabel title = new JLabel(aboutInfo);
        about.add(title);
        about.add(new JLabel("Kernel version: " + Gateway.getKernelVersion()));
        about.add(new JLabel("Modules loaded: " + Gateway.getModuleManager().getModuleVersions()));
        StringBuffer lictxt = new StringBuffer();
        try {
            lictxt.append(Gateway.getResource().getTextResource(null, "textFiles/license.html"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        for (String ns : Gateway.getResource().getModuleBaseURLs().keySet()) {
            try {
                String domlictxt = Gateway.getResource().getTextResource(ns, "license.html");
                lictxt.append(domlictxt).append("\n");
            }
            catch (ObjectNotFoundException objectNotFoundException) {}
        }
        JEditorPane license = new JEditorPane();
        license.setEditable(false);
        license.setEditorKit(new HTMLEditorKit());
        license.setContentType("text/html");
        license.addHyperlinkListener(this);
        license.setText(lictxt.toString());
        JScrollPane scroll = new JScrollPane(license);
        scroll.setPreferredSize(new Dimension(300, 200));
        license.setCaretPosition(0);
        about.add(scroll);
        myPane.setMessage(about);
        myPane.setMessageType(1);
        JDialog dialog = myPane.createDialog(null, "About");
        dialog.setResizable(false);
        ImageIcon icon = ImageLoader.findImage(Gateway.getProperties().getString("banner"));
        myPane.setIcon(icon);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + e.getURL().toString());
            }
        }
        catch (Exception ex) {
            MainFrame.exceptionDialog(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

