/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.cristalise.gui.Frame2_Cancel_actionAdapter;
import org.cristalise.gui.Frame2_OK_actionAdapter;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.LoginBox_this_keyAdapter;
import org.cristalise.gui.MainFrame;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class LoginBox
extends JFrame {
    public String errorMessage = new String("");
    String title;
    private int maxNumberLogon;
    public boolean action = false;
    public int loginAttemptNumber = 0;
    JLabel passwordLabel = new JLabel();
    JTextField username = new JTextField();
    JButton OK = new JButton();
    JLabel errorLabel = new JLabel();
    JPasswordField password = new JPasswordField();
    JButton Cancel = new JButton();
    JLabel userLabel = new JLabel();
    ImageIcon imageMainHolder = new ImageIcon();
    JLabel pictureLabel = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    MainFrame mainFrameFather;
    public static AgentProxy userAgent;
    private boolean logged;
    private boolean errorSet;

    public LoginBox(int attempt, String title, String lastUser, String bottomMessage, ImageIcon imageHolder, MainFrame mainFrame) {
        String iconFile = Gateway.getProperties().getString("AppIcon");
        if (iconFile != null) {
            this.setIconImage(ImageLoader.findImage(iconFile).getImage());
        }
        this.errorLabel.setText(bottomMessage);
        if (this.errorMessage.compareTo("") != 0) {
            this.errorLabel.setText(this.errorMessage);
        }
        this.mainFrameFather = mainFrame;
        this.imageMainHolder = imageHolder;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.maxNumberLogon = attempt == 0 ? 5 : attempt;
        this.title = title == null ? "Cristal" : title;
        this.setTitle("Log in to " + title);
        this.username.setText(lastUser);
    }

    private void loginClicked() {
        this.errorSet = false;
        try {
            if (this.getUser().length() > 0 && this.getPassword().length() > 0) {
                userAgent = Gateway.connect((String)this.getUser(), (String)this.getPassword(), (String)this.title);
            }
            this.logged = userAgent != null;
            Logger.msg((int)7, (String)"AbstractMain::standardSetUp() - Gateway.connect() OK.", (Object[])new Object[0]);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            int i = ex.getMessage().indexOf(32);
            if (i > -1) {
                message = message.substring(i);
            }
            this.errorLabel.setText(message);
            Logger.error((String)message, (Object[])new Object[0]);
            this.logged = false;
            this.errorSet = true;
        }
        if (!this.logged) {
            Logger.msg((String)("Login attempt " + this.loginAttemptNumber + " of " + this.maxNumberLogon + " failed"), (Object[])new Object[0]);
            if (this.loginAttemptNumber >= this.maxNumberLogon) {
                this.dispose();
                Logger.error((String)"Login failure limit reached", (Object[])new Object[0]);
                AbstractMain.shutdown((int)1);
            }
            if (!this.errorSet) {
                this.errorLabel.setText("Please enter username & password");
            }
            this.validate();
        } else {
            MainFrame.userAgent = userAgent;
            this.setVisible(false);
            this.mainFrameFather.mainFrameShow();
            Logger.msg((int)1, (String)("Login attempt " + this.loginAttemptNumber + " of " + this.maxNumberLogon + " succeeded."), (Object[])new Object[0]);
            this.dispose();
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AbstractMain.shutdown((int)0);
            }
        });
        this.setEnabled(true);
        this.setLocale(Locale.getDefault());
        this.setResizable(false);
        this.setState(0);
        this.setTitle("");
        LoginBox_this_keyAdapter submitListener = new LoginBox_this_keyAdapter(this);
        this.username.addKeyListener(submitListener);
        this.password.addKeyListener(submitListener);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.passwordLabel.setText("Password:");
        this.OK.setActionCommand("OK");
        this.OK.setSelected(true);
        this.OK.setText("OK");
        this.OK.addActionListener(new Frame2_OK_actionAdapter(this));
        this.OK.setPreferredSize(new Dimension(80, 30));
        this.Cancel.setActionCommand("Cancel");
        this.Cancel.setText("Cancel");
        this.Cancel.addActionListener(new Frame2_Cancel_actionAdapter(this));
        this.Cancel.setPreferredSize(new Dimension(80, 30));
        this.userLabel.setText("User:");
        this.pictureLabel = new JLabel(this.imageMainHolder);
        this.pictureLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.password.setText("");
        this.username.setText("");
        GridBagConstraints c = new GridBagConstraints();
        this.initBasicConstraints(c, 1, 1, 1, 4);
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.pictureLabel, c);
        this.initBasicConstraints(c, 2, 1, 1, 1);
        c.anchor = 16;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.userLabel, c);
        this.initBasicConstraints(c, 2, 2, 1, 1);
        c.anchor = 16;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.passwordLabel, c);
        this.initBasicConstraints(c, 3, 1, 1, 1);
        c.anchor = 15;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.username, c);
        this.initBasicConstraints(c, 3, 2, 1, 1);
        c.anchor = 15;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.password, c);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.add(Box.createGlue());
        buttonPane.add(this.OK);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(this.Cancel);
        buttonPane.add(Box.createGlue());
        buttonPane.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.initBasicConstraints(c, 2, 3, 2, 1);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 15;
        c.fill = 1;
        this.getContentPane().add((Component)buttonPane, c);
        this.initBasicConstraints(c, 2, 4, 2, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 14;
        JPanel msgPane = new JPanel();
        msgPane.setLayout(new BoxLayout(msgPane, 0));
        msgPane.add(Box.createGlue());
        msgPane.add(this.errorLabel);
        msgPane.add(Box.createGlue());
        this.getContentPane().add((Component)msgPane, c);
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 5));
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screen.width / 2 - this.getWidth() / 2, screen.height / 2 - this.getHeight() / 2);
    }

    protected void initBasicConstraints(GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
    }

    public String getUser() {
        return this.username.getText();
    }

    public String getPassword() {
        return String.valueOf(this.password.getPassword());
    }

    void Cancel_actionPerformed(ActionEvent e) {
        this.dispose();
        Logger.msg((String)"User cancelled login.", (Object[])new Object[0]);
        AbstractMain.shutdown((int)0);
    }

    void OK_actionPerformed(ActionEvent e) {
        try {
            ++this.loginAttemptNumber;
            this.loginClicked();
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
    }

    void this_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            try {
                ++this.loginAttemptNumber;
                this.loginClicked();
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
            }
        }
    }
}

