/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.graph.controller.ElasticBand;
import org.cristalise.gui.graph.controller.Selection;
import org.cristalise.gui.graph.event.ElasticBandResizedEvent;
import org.cristalise.gui.graph.event.ElasticBandSetEvent;
import org.cristalise.gui.graph.event.SelectionChangedEvent;
import org.cristalise.gui.graph.event.SelectionMovedEvent;
import org.cristalise.gui.graph.view.DirectedEdgeRenderer;
import org.cristalise.gui.graph.view.VertexRenderer;
import org.cristalise.kernel.graph.event.EntireModelChangedEvent;
import org.cristalise.kernel.graph.event.GraphModelEvent;
import org.cristalise.kernel.graph.event.GraphModelResizedEvent;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;

public class GraphPanel
extends JPanel
implements Observer {
    protected Selection mSelection = new Selection(null, null, 0, 0, 0, 0);
    private ElasticBand mElasticBand = null;
    protected final Paint mSelectionPaint = Color.black;
    protected final Paint mStartPaint = Color.green;
    protected final Image mResizePadImg = ImageLoader.findImage("graph/resizepad.gif").getImage();
    protected final BasicStroke mDashed = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
    protected GraphModelManager mGraphModelManager = null;
    protected VertexRenderer mVertexRenderer = null;
    protected DirectedEdgeRenderer mDirectedEdgeRenderer = null;
    private final SelectionChangedEvent mSelectionChangedEvent = new SelectionChangedEvent();
    private final SelectionMovedEvent mSelectionMovedEvent = new SelectionMovedEvent();
    private final ElasticBandResizedEvent mElasticBandResizedEvent = new ElasticBandResizedEvent();
    private final ElasticBandSetEvent mElasticBandSetEvent = new ElasticBandSetEvent();

    public GraphPanel(DirectedEdgeRenderer eRenderer, VertexRenderer vRenderer) {
        this.mVertexRenderer = vRenderer;
        this.mDirectedEdgeRenderer = eRenderer;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                GraphPanel.this.requestFocus();
            }
        });
    }

    public void setGraphModelManager(GraphModelManager graphModelManager) {
        this.mGraphModelManager = graphModelManager;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof EntireModelChangedEvent) {
            this.mSelection = new Selection(null, null, 0, 0, 0, 0);
        }
        if (arg instanceof GraphModelResizedEvent || arg instanceof EntireModelChangedEvent) {
            this.setPreferredSize(new Dimension(this.mGraphModelManager.getModel().getWidth(), this.mGraphModelManager.getModel().getHeight()));
            this.revalidate();
        }
        this.repaint();
    }

    private void updateSelectionCorners() {
        Vertex vertex = this.mSelection.mVertices[0];
        GraphPoint centrePoint = vertex.getCentrePoint();
        if (centrePoint == null) {
            return;
        }
        this.mSelection.mTopLeftX = centrePoint.x;
        this.mSelection.mTopLeftY = centrePoint.y;
        this.mSelection.mBottomRightX = centrePoint.x;
        this.mSelection.mBottomRightY = centrePoint.y;
        Vertex[] vertexArray = this.mSelection.mVertices;
        int n = vertexArray.length;
        for (int i = 0; i < n; ++i) {
            Vertex mVertice;
            vertex = mVertice = vertexArray[i];
            centrePoint = vertex.getCentrePoint();
            if (centrePoint.x < this.mSelection.mTopLeftX) {
                this.mSelection.mTopLeftX = centrePoint.x;
            }
            if (centrePoint.y < this.mSelection.mTopLeftY) {
                this.mSelection.mTopLeftY = centrePoint.y;
            }
            if (centrePoint.x > this.mSelection.mBottomRightX) {
                this.mSelection.mBottomRightX = centrePoint.x;
            }
            if (centrePoint.y <= this.mSelection.mBottomRightY) continue;
            this.mSelection.mBottomRightY = centrePoint.y;
        }
    }

    public void deleteSelection() {
        int i = 0;
        if (this.mSelection.mVertices != null) {
            for (i = 0; i < this.mSelection.mVertices.length; ++i) {
                this.mGraphModelManager.getModel().removeVertex(this.mSelection.mVertices[i]);
            }
        } else if (this.mSelection.mEdge != null) {
            this.mGraphModelManager.getModel().removeEdge(this.mSelection.mEdge);
        }
        if (this.mSelection.mEdge != null || this.mSelection.mVertices != null) {
            this.mSelection.mEdge = null;
            this.mSelection.mVertices = null;
            this.mSelectionChangedEvent.mSelection = this.mSelection;
            this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mSelectionChangedEvent);
        }
    }

    public void selectAll() {
        Vertex[] allVertices = this.mGraphModelManager.getModel().getVertices();
        if (allVertices.length > 0) {
            this.mSelection.mEdge = null;
            this.mSelection.mVertices = allVertices;
            this.updateSelectionCorners();
            this.mSelectionChangedEvent.mSelection = this.mSelection;
            this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mSelectionChangedEvent);
        }
    }

    public void selectContentsOfElasticBand() {
        if (this.mElasticBand == null) {
            return;
        }
        Polygon bandPolygon = new Polygon();
        Vertex[] allVertices = this.mGraphModelManager.getModel().getVertices();
        GraphPoint centrePoint = null;
        Vector<Object> verticesInside = new Vector<Object>(10, 10);
        int i = 0;
        bandPolygon.addPoint(this.mElasticBand.mFixedCorner.x, this.mElasticBand.mFixedCorner.y);
        bandPolygon.addPoint(this.mElasticBand.mMovingCorner.x, this.mElasticBand.mFixedCorner.y);
        bandPolygon.addPoint(this.mElasticBand.mMovingCorner.x, this.mElasticBand.mMovingCorner.y);
        bandPolygon.addPoint(this.mElasticBand.mFixedCorner.x, this.mElasticBand.mMovingCorner.y);
        for (i = 0; i < allVertices.length; ++i) {
            centrePoint = allVertices[i].getCentrePoint();
            if (!bandPolygon.contains(centrePoint.x, centrePoint.y)) continue;
            verticesInside.add(allVertices[i]);
        }
        if (verticesInside.size() == 0) {
            this.mSelection.mTopLeftX = 0;
            this.mSelection.mTopLeftY = 0;
            this.mSelection.mBottomRightX = 0;
            this.mSelection.mBottomRightY = 0;
            this.mSelection.mEdge = null;
            if (this.mGraphModelManager.getModel().getContainingVertex() != null) {
                verticesInside.add(this.mGraphModelManager.getModel().getContainingVertex());
            } else {
                this.mSelection.mVertices = null;
            }
        }
        if (verticesInside.size() > 0) {
            this.mSelection.mEdge = null;
            this.mSelection.mVertices = new Vertex[verticesInside.size()];
            for (i = 0; i < verticesInside.size(); ++i) {
                this.mSelection.mVertices[i] = (Vertex)verticesInside.elementAt(i);
            }
            this.updateSelectionCorners();
        }
        this.mElasticBand = null;
        this.mSelectionChangedEvent.mSelection = this.mSelection;
        this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mSelectionChangedEvent);
    }

    public void setSelectedVertexToBeStart() {
        if (this.mSelection.mVertices != null && this.mSelection.mVertices.length == 1) {
            this.mGraphModelManager.getModel().setStartVertexId(this.mSelection.mVertices[0].getID());
        }
    }

    public Selection getSelection() {
        return this.mSelection;
    }

    public void setElasticBand(ElasticBand elasticBand) {
        this.mElasticBand = elasticBand;
        this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mElasticBandSetEvent);
    }

    public void resizeElasticBand(GraphPoint movingCorner) {
        this.mElasticBand.mMovingCorner = movingCorner;
        this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mElasticBandResizedEvent);
    }

    public boolean inSelection(Vertex v) {
        int i = 0;
        if (this.mSelection.mVertices == null) {
            return false;
        }
        for (i = 0; i < this.mSelection.mVertices.length; ++i) {
            if (this.mSelection.mVertices[i] != v) continue;
            return true;
        }
        return false;
    }

    public void removeFromSelection(Vertex v) {
        Vertex[] vertices = null;
        int i = 0;
        int j = 0;
        if (this.mSelection.mVertices.length == 1) {
            this.mSelection.mVertices = null;
            this.mSelection.mTopLeftX = 0;
            this.mSelection.mTopLeftY = 0;
            this.mSelection.mBottomRightX = 0;
            this.mSelection.mBottomRightY = 0;
        } else {
            vertices = new Vertex[this.mSelection.mVertices.length - 1];
            for (i = 0; i < this.mSelection.mVertices.length; ++i) {
                if (this.mSelection.mVertices[i] == v) continue;
                vertices[j] = this.mSelection.mVertices[i];
                ++j;
            }
            this.mSelection.mVertices = vertices;
            this.updateSelectionCorners();
        }
        this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mSelectionChangedEvent);
    }

    public void addToSelection(Vertex v) {
        Vertex[] vertices = new Vertex[this.mSelection.mVertices.length + 1];
        GraphPoint centrePoint = null;
        int i = 0;
        if (this.mSelection.mVertices == null) {
            centrePoint = v.getCentrePoint();
            this.mSelection.mVertices = new Vertex[]{v};
            this.mSelection.mTopLeftX = centrePoint.x;
            this.mSelection.mTopLeftY = centrePoint.y;
            this.mSelection.mBottomRightX = centrePoint.x;
            this.mSelection.mBottomRightY = centrePoint.y;
        } else {
            for (i = 0; i < this.mSelection.mVertices.length; ++i) {
                vertices[i] = this.mSelection.mVertices[i];
            }
            vertices[this.mSelection.mVertices.length] = v;
            this.mSelection.mVertices = vertices;
            this.updateSelectionCorners();
        }
        this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mSelectionChangedEvent);
    }

    public void moveAbsoluteSelection(int newTopLeftX, int newTopLeftY) {
        int graphHeight;
        int graphWidth;
        int selectionHeight = this.mSelection.mBottomRightY - this.mSelection.mTopLeftY;
        int selectionWidth = this.mSelection.mBottomRightX - this.mSelection.mTopLeftX;
        int bottomRightX = newTopLeftX + selectionWidth;
        int bottomRightY = newTopLeftY + selectionHeight;
        GraphPoint oldCentrePoint = null;
        GraphPoint newCentrePoint = null;
        int distXFromTopLeft = 0;
        int distYFromTopLeft = 0;
        int i = 0;
        if (newTopLeftX < 0) {
            newTopLeftX = 0;
        }
        if (newTopLeftY < 0) {
            newTopLeftY = 0;
        }
        if (bottomRightX > (graphWidth = this.mGraphModelManager.getModel().getWidth())) {
            newTopLeftX = graphWidth - selectionWidth;
        }
        if (bottomRightY > (graphHeight = this.mGraphModelManager.getModel().getHeight())) {
            newTopLeftY = graphHeight - selectionHeight;
        }
        for (i = 0; i < this.mSelection.mVertices.length; ++i) {
            oldCentrePoint = this.mSelection.mVertices[i].getCentrePoint();
            distXFromTopLeft = oldCentrePoint.x - this.mSelection.mTopLeftX;
            distYFromTopLeft = oldCentrePoint.y - this.mSelection.mTopLeftY;
            newCentrePoint = new GraphPoint(newTopLeftX + distXFromTopLeft, newTopLeftY + distYFromTopLeft);
            this.mGraphModelManager.getModel().moveAbsoluteVertex(this.mSelection.mVertices[i], newCentrePoint);
        }
        this.mSelection.mTopLeftX = newTopLeftX;
        this.mSelection.mTopLeftY = newTopLeftY;
        this.mSelection.mBottomRightX = newTopLeftX + selectionWidth;
        this.mSelection.mBottomRightY = newTopLeftY + selectionHeight;
        this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mSelectionMovedEvent);
    }

    public Vertex getVertex(GraphPoint p) {
        Vertex[] vertexObjs = this.mGraphModelManager.getModel().getVertices();
        Vertex vertex = null;
        Vector<Vertex> vertexVector = new Vector<Vertex>(10, 10);
        int numVerticesFound = 0;
        Vertex smallestVertex = null;
        int sizeOfSmallestVertex = 0;
        int sizeOfVertex = 0;
        int i = 0;
        for (i = 0; i < vertexObjs.length; ++i) {
            vertex = vertexObjs[i];
            if (!vertex.containsPoint(p)) continue;
            vertexVector.add(vertex);
        }
        numVerticesFound = vertexVector.size();
        if (numVerticesFound == 0) {
            return null;
        }
        smallestVertex = (Vertex)vertexVector.elementAt(0);
        sizeOfSmallestVertex = smallestVertex.getHeight() * smallestVertex.getWidth();
        for (i = 1; i < numVerticesFound; ++i) {
            vertex = (Vertex)vertexVector.elementAt(i);
            sizeOfVertex = vertex.getHeight() * vertex.getWidth();
            if (sizeOfVertex >= sizeOfSmallestVertex) continue;
            smallestVertex = vertex;
            sizeOfSmallestVertex = sizeOfVertex;
        }
        return smallestVertex;
    }

    public DirectedEdge getEdge(GraphPoint p) {
        DirectedEdge[] edgeObjs = this.mGraphModelManager.getModel().getEdges();
        DirectedEdge edge = null;
        int i = 0;
        for (i = 0; i < edgeObjs.length; ++i) {
            edge = edgeObjs[i];
            if (!edge.containsPoint(p)) continue;
            return edge;
        }
        return null;
    }

    public void setSelection(Selection s) {
        if (this.selectionChanged(s)) {
            this.mSelection = s;
            this.mSelectionChangedEvent.mSelection = s;
            this.mGraphModelManager.notifyObservers((GraphModelEvent)this.mSelectionChangedEvent);
        }
    }

    private boolean selectionChanged(Selection newValue) {
        int i = 0;
        if (this.mSelection.mEdge != newValue.mEdge) {
            return true;
        }
        if (this.mSelection.mVertices == null) {
            return newValue.mVertices != null;
        }
        if (newValue.mVertices == null) {
            return true;
        }
        if (this.mSelection.mVertices.length != newValue.mVertices.length) {
            return true;
        }
        for (i = 0; i < this.mSelection.mVertices.length; ++i) {
            if (this.mSelection.mVertices[i] == newValue.mVertices[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        DirectedEdge[] edges = null;
        Vertex[] vertices = null;
        Vertex startVertex = null;
        Vertex newEdgeOriginVertex = null;
        GraphPoint newEdgeOriginPoint = null;
        GraphPoint newEdgeEndPoint = null;
        GraphPoint vertexCentre = null;
        int i = 0;
        super.paintComponent(g);
        if (this.mGraphModelManager != null) {
            edges = this.mGraphModelManager.getModel().getEdges();
            vertices = this.mGraphModelManager.getModel().getVertices();
            for (i = 0; i < edges.length; ++i) {
                this.mDirectedEdgeRenderer.draw(g2d, edges[i]);
            }
            for (i = 0; i < vertices.length; ++i) {
                this.mVertexRenderer.draw(g2d, vertices[i]);
            }
            g2d.setPaint(this.mStartPaint);
            startVertex = this.mGraphModelManager.getModel().getStartVertex();
            if (startVertex != null) {
                this.drawVertexHighlight(g2d, startVertex, 1);
            }
            g2d.setPaint(this.mSelectionPaint);
            if (this.mSelection.mVertices != null) {
                g2d.setStroke(this.mDashed);
                for (i = 0; i < this.mSelection.mVertices.length; ++i) {
                    if (this.mSelection.mVertices[i] == this.mGraphModelManager.getModel().getContainingVertex()) continue;
                    this.drawVertexHighlight(g2d, this.mSelection.mVertices[i], 5);
                }
                if (this.mSelection.mVertices.length == 1 && this.mSelection.mVertices[0] != this.mGraphModelManager.getModel().getContainingVertex()) {
                    vertexCentre = this.mSelection.mVertices[0].getCentrePoint();
                    g2d.drawImage(this.mResizePadImg, vertexCentre.x + this.mSelection.mVertices[0].getWidth() / 2, vertexCentre.y + this.mSelection.mVertices[0].getHeight() / 2, this);
                }
            }
            if (this.mSelection.mEdge != null) {
                this.drawEdgeHighlight(g2d, this.mSelection.mEdge);
            }
            if (this.mElasticBand != null) {
                g2d.drawLine(this.mElasticBand.mFixedCorner.x, this.mElasticBand.mFixedCorner.y, this.mElasticBand.mMovingCorner.x, this.mElasticBand.mFixedCorner.y);
                g2d.drawLine(this.mElasticBand.mMovingCorner.x, this.mElasticBand.mFixedCorner.y, this.mElasticBand.mMovingCorner.x, this.mElasticBand.mMovingCorner.y);
                g2d.drawLine(this.mElasticBand.mMovingCorner.x, this.mElasticBand.mMovingCorner.y, this.mElasticBand.mFixedCorner.x, this.mElasticBand.mMovingCorner.y);
                g2d.drawLine(this.mElasticBand.mFixedCorner.x, this.mElasticBand.mMovingCorner.y, this.mElasticBand.mFixedCorner.x, this.mElasticBand.mFixedCorner.y);
            }
            newEdgeEndPoint = this.mGraphModelManager.getModel().getNewEdgeEndPoint();
            newEdgeOriginVertex = this.mGraphModelManager.getModel().getNewEdgeOriginVertex();
            if (newEdgeEndPoint != null && newEdgeOriginVertex != null) {
                newEdgeOriginPoint = newEdgeOriginVertex.getCentrePoint();
                g2d.setPaint(Color.black);
                g2d.drawLine(newEdgeOriginPoint.x, newEdgeOriginPoint.y, newEdgeEndPoint.x, newEdgeEndPoint.y);
            }
        }
    }

    protected void drawVertexHighlight(Graphics2D g2d, Vertex vertex, int dist) {
        GraphPoint[] outlinePoints = vertex.getOutlinePoints();
        GraphPoint centrePoint = vertex.getCentrePoint();
        int i = 0;
        for (i = 0; i < outlinePoints.length - 1; ++i) {
            GraphPanel.drawShiftedLine(dist, g2d, centrePoint, outlinePoints[i].x, outlinePoints[i].y, outlinePoints[i + 1].x, outlinePoints[i + 1].y);
        }
        GraphPanel.drawShiftedLine(dist, g2d, centrePoint, outlinePoints[outlinePoints.length - 1].x, outlinePoints[outlinePoints.length - 1].y, outlinePoints[0].x, outlinePoints[0].y);
    }

    private static void drawShiftedLine(int dist, Graphics2D g2d, GraphPoint centrePoint, int x1, int y1, int x2, int y2) {
        if (x1 > centrePoint.x) {
            x1 += dist;
        }
        if (x1 < centrePoint.x) {
            x1 -= dist;
        }
        if (y1 > centrePoint.y) {
            y1 += dist;
        }
        if (y1 < centrePoint.y) {
            y1 -= dist;
        }
        if (x2 > centrePoint.x) {
            x2 += dist;
        }
        if (x2 < centrePoint.x) {
            x2 -= dist;
        }
        if (y2 > centrePoint.y) {
            y2 += dist;
        }
        if (y2 < centrePoint.y) {
            y2 -= dist;
        }
        g2d.drawLine(x1, y1, x2, y2);
    }

    protected void drawEdgeHighlight(Graphics2D g2d, DirectedEdge edge) {
        GraphPoint originPoint = edge.getOriginPoint();
        GraphPoint terminusPoint = edge.getTerminusPoint();
        int midX = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
        int midY = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
        int minX = midX - 10;
        int minY = midY - 10;
        int maxX = midX + 10;
        int maxY = midY + 10;
        g2d.drawLine(minX, minY, maxX, minY);
        g2d.drawLine(maxX, minY, maxX, maxY);
        g2d.drawLine(maxX, maxY, minX, maxY);
        g2d.drawLine(minX, maxY, minX, minY);
    }

    @Override
    public void printComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        DirectedEdge[] edges = null;
        Vertex[] vertices = null;
        Vertex startVertex = null;
        int i = 0;
        g.setColor(Color.white);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mGraphModelManager != null) {
            edges = this.mGraphModelManager.getModel().getEdges();
            vertices = this.mGraphModelManager.getModel().getVertices();
            for (i = 0; i < edges.length; ++i) {
                this.mDirectedEdgeRenderer.draw(g2d, edges[i]);
            }
            for (i = 0; i < vertices.length; ++i) {
                this.mVertexRenderer.draw(g2d, vertices[i]);
            }
            g2d.setPaint(this.mStartPaint);
            startVertex = this.mGraphModelManager.getModel().getStartVertex();
            if (startVertex != null) {
                this.drawVertexHighlight(g2d, startVertex, 1);
            }
        }
    }

    protected void superPaint(Graphics g) {
        super.paintComponent(g);
    }
}

