/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.view;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.graph.event.SelectionChangedEvent;
import org.cristalise.gui.graph.view.PropertyTable;
import org.cristalise.gui.graph.view.PropertyTableModel;
import org.cristalise.gui.graph.view.SelectedVertexPanel;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.kernel.graph.event.EntireModelChangedEvent;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.GraphableEdge;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.utils.CastorHashMap;

public class VertexPropertyPanel
extends JPanel
implements Observer,
TableModelListener,
ActionListener {
    private final PropertyTableModel mPropertyModel;
    private final PropertyTable mPropertyTable;
    private GraphModelManager mGraphModelManager;
    private boolean isEditable = false;
    GridBagLayout gridbag = new GridBagLayout();
    protected JLabel selObjName;
    protected JLabel selObjClass;
    JButton addPropButton;
    JButton delPropButton;
    Box newPropBox;
    private JTextField newPropName;
    private JComboBox newPropType;
    private JCheckBox newPropAbstract;
    private boolean useAbstract;
    String[] typeOptions = new String[]{"String", "Boolean", "Integer", "Float"};
    String[] typeInitVal = new String[]{"", "false", "0", "0.0"};
    SelectedVertexPanel mSelPanel;

    public VertexPropertyPanel(boolean useAbstract) {
        this.setLayout(this.gridbag);
        this.useAbstract = useAbstract;
        this.mPropertyModel = new PropertyTableModel(useAbstract);
        this.mPropertyModel.addTableModelListener(this);
        this.mPropertyTable = new PropertyTable(this.mPropertyModel);
    }

    @Override
    public void update(Observable o, Object arg) {
        Vertex[] selectedVertices = null;
        DirectedEdge selectedEdge = null;
        if (arg instanceof SelectionChangedEvent) {
            SelectionChangedEvent event = (SelectionChangedEvent)((Object)arg);
            selectedVertices = event.mSelection.mVertices;
            if (selectedVertices != null && selectedVertices.length == 1) {
                this.setVertex(selectedVertices[0]);
                return;
            }
            selectedEdge = event.mSelection.mEdge;
            if (selectedEdge != null) {
                this.setEdge(selectedEdge);
                return;
            }
        }
        if (arg instanceof SelectionChangedEvent || arg instanceof EntireModelChangedEvent) {
            this.clear();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.mGraphModelManager != null) {
            this.mGraphModelManager.forceNotify();
        }
    }

    public void setVertex(Vertex vert) {
        if (vert.getName().equals("domain")) {
            this.selObjName.setText("Domain Workflow");
        } else {
            this.selObjName.setText(vert.getName());
        }
        String className = vert.getClass().getName();
        this.selObjClass.setText(className.substring(className.lastIndexOf(46) + 1));
        if (this.mSelPanel != null) {
            this.mSelPanel.select(vert);
        }
        if (vert instanceof GraphableVertex) {
            this.mPropertyModel.setMap(((GraphableVertex)vert).getProperties());
            this.addPropButton.setEnabled(this.isEditable);
            this.delPropButton.setEnabled(this.isEditable);
        }
    }

    public void setEdge(DirectedEdge edge) {
        this.selObjName.setText(edge.getName());
        String className = edge.getClass().getName();
        this.selObjClass.setText(className.substring(className.lastIndexOf(46) + 1));
        if (edge instanceof GraphableEdge) {
            this.mPropertyModel.setMap(((GraphableEdge)edge).getProperties());
            this.addPropButton.setEnabled(this.isEditable);
            this.delPropButton.setEnabled(this.isEditable);
        }
        if (this.mSelPanel != null) {
            this.mSelPanel.clear();
        }
    }

    public void clear() {
        this.selObjName.setText("");
        this.selObjClass.setText("Nothing Selected");
        this.mPropertyModel.setMap(new CastorHashMap());
        if (this.mSelPanel != null) {
            this.mSelPanel.clear();
        }
        this.addPropButton.setEnabled(false);
        this.delPropButton.setEnabled(false);
    }

    public void setEditable(boolean editable) {
        this.mPropertyModel.setEditable(editable);
        this.isEditable = editable;
        this.newPropBox.setVisible(editable);
    }

    public void setGraphModelManager(GraphModelManager manager) {
        this.mGraphModelManager = manager;
        manager.addObserver((Observer)this);
    }

    public void createLayout(SelectedVertexPanel selPanel) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.ipadx = 5;
        c.ipady = 5;
        this.selObjName = new JLabel();
        this.selObjName.setFont(ItemTabPane.titleFont);
        this.gridbag.setConstraints(this.selObjName, c);
        this.add(this.selObjName);
        ++c.gridy;
        this.selObjClass = new JLabel();
        this.gridbag.setConstraints(this.selObjClass, c);
        this.add(this.selObjClass);
        ++c.gridy;
        JLabel title = new JLabel("Properties");
        title.setFont(ItemTabPane.titleFont);
        this.gridbag.setConstraints(title, c);
        this.add(title);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 2.0;
        JScrollPane scroll = new JScrollPane(this.mPropertyTable);
        this.gridbag.setConstraints(scroll, c);
        this.add(scroll);
        this.newPropBox = Box.createHorizontalBox();
        this.newPropBox.add(new JLabel("New :"));
        this.newPropBox.add(Box.createHorizontalGlue());
        this.newPropName = new JTextField(15);
        this.newPropBox.add(this.newPropName);
        this.newPropType = new JComboBox<String>(this.typeOptions);
        this.newPropBox.add(this.newPropType);
        this.newPropBox.add(Box.createHorizontalGlue());
        this.newPropAbstract = new JCheckBox();
        if (this.useAbstract) {
            this.newPropBox.add(this.newPropAbstract);
            this.newPropBox.add(Box.createHorizontalStrut(1));
            this.newPropBox.add(new JLabel("Abstract"));
            this.newPropBox.add(Box.createHorizontalStrut(1));
        }
        this.addPropButton = new JButton("Add");
        this.addPropButton.setMargin(new Insets(0, 0, 0, 0));
        this.delPropButton = new JButton("Del");
        this.delPropButton.setMargin(new Insets(0, 0, 0, 0));
        this.addPropButton.addActionListener(this);
        this.delPropButton.addActionListener(this);
        this.newPropBox.add(this.addPropButton);
        this.newPropBox.add(this.delPropButton);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        this.gridbag.setConstraints(this.newPropBox, c);
        this.add(this.newPropBox);
        if (selPanel != null) {
            ++c.gridy;
            this.mSelPanel = selPanel;
            this.gridbag.setConstraints(this.mSelPanel, c);
            this.add(this.mSelPanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addPropButton) {
            if (this.newPropName.getText().length() < 1) {
                JOptionPane.showMessageDialog(this, "Enter a name for the new property", "Cannot add property", 0);
                return;
            }
            if (this.mPropertyModel.sourceMap.containsKey((Object)this.newPropName.getText())) {
                JOptionPane.showMessageDialog(this, "Property '" + this.newPropName.getText() + "' already exists.", "Cannot add property", 0);
                return;
            }
            if (this.mPropertyTable.getCellEditor() != null) {
                this.mPropertyTable.getCellEditor().stopCellEditing();
            }
            try {
                Class<?> newPropClass = Class.forName("java.lang." + this.typeOptions[this.newPropType.getSelectedIndex()]);
                Class[] params = new Class[]{String.class};
                Constructor<?> init = newPropClass.getConstructor(params);
                Object[] initParams = new Object[]{this.typeInitVal[this.newPropType.getSelectedIndex()]};
                this.mPropertyModel.addProperty(this.newPropName.getText(), init.newInstance(initParams), this.newPropAbstract.isSelected());
            }
            catch (Exception ex) {
                MainFrame.exceptionDialog(ex);
            }
        } else if (e.getSource() == this.delPropButton) {
            int selrow = this.mPropertyTable.getSelectedRow();
            if (selrow == -1) {
                JOptionPane.showMessageDialog(this, "Select a property to remove", "Cannot delete property", 0);
                return;
            }
            this.mPropertyModel.delProperty(this.mPropertyModel.sortedNameList.get(selrow));
        }
    }
}

