/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.chooser;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.lifecycle.chooser.LDAPEntryChooser;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.Logger;

public class LDAPFileChooser
extends JPanel {
    public static String SCRIPT_CHOOSER = "Script";
    public static String SCHEMA_CHOOSER = "Schema";
    public static String ELEM_ACTIVITY_CHOOSER = "Atomic";
    public static String COMP_ACTIVITY_CHOOSER = "Composite";
    private String chooserMode = null;
    public LDAPEntryChooser mLec;
    JComboBox<Integer> mVer;
    ArrayList<Property> props = new ArrayList();
    String schemaName = null;

    public LDAPFileChooser(String choose) {
        this.chooserMode = choose;
        this.initialise();
    }

    private void initialise() {
        if (this.chooserMode.equals(SCHEMA_CHOOSER)) {
            this.props.add(new Property("Type", "Schema"));
            this.schemaName = "Schema";
        } else if (this.chooserMode.equals(SCRIPT_CHOOSER)) {
            this.props.add(new Property("Type", "Script"));
            this.schemaName = "Schema";
        } else if (this.chooserMode.equals(ELEM_ACTIVITY_CHOOSER)) {
            this.props.add(new Property("Type", "ActivityDesc"));
            this.props.add(new Property("Complexity", "Elementary"));
            this.schemaName = "ElementaryActivityDef";
        } else if (this.chooserMode.equals(COMP_ACTIVITY_CHOOSER)) {
            this.props.add(new Property("Type", "ActivityDesc"));
            this.props.add(new Property("Complexity", "Composite"));
            this.schemaName = "CompositeActivityDef";
        } else {
            return;
        }
        this.mLec = new LDAPEntryChooser(this.props);
        this.mLec.setPreferredSize(new Dimension(220, 19));
        this.mLec.setMaximumSize(new Dimension(3000, 22));
        this.mLec.setMinimumSize(new Dimension(50, 19));
        BoxLayout blyt = new BoxLayout(this, 0);
        this.setLayout(blyt);
        this.add(this.mLec);
        this.add(Box.createHorizontalStrut(5));
        this.add(new JLabel("Version:"));
        this.mVer = new JComboBox();
        this.mVer.setPreferredSize(new Dimension(50, 19));
        this.mVer.setMaximumSize(new Dimension(50, 22));
        this.mVer.setMinimumSize(new Dimension(50, 19));
        this.add(this.mVer);
        this.mLec.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LDAPFileChooser.this.mVer.removeAllItems();
                String selectedItem = (String)e.getItem();
                if (selectedItem != null && selectedItem.length() > 0) {
                    try {
                        String[] views;
                        for (String thisVer : views = Gateway.getStorage().getClusterContents(LDAPFileChooser.this.mLec.getItem(selectedItem), ClusterStorage.VIEWPOINT + "/" + LDAPFileChooser.this.schemaName)) {
                            try {
                                LDAPFileChooser.this.mVer.addItem(Integer.parseInt(thisVer));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (PersistencyException ex) {
                        MainFrame.exceptionDialog((Exception)((Object)ex));
                    }
                }
            }
        });
        this.validate();
        this.setVisible(true);
    }

    public String getEntryName() {
        return (String)this.mLec.getSelectedItem();
    }

    public void addItemListener(ItemListener il) {
        this.mLec.addItemListener(il);
    }

    public void setSelectedItem(String name, String version) {
        Logger.debug((int)5, (String)("setSelectedItem " + name + " " + version), (Object[])new Object[0]);
        if (name == null || name.equals("-1")) {
            name = "";
        }
        this.mLec.setSelectedItem(name);
    }

    public void reload() {
        this.mLec.reload();
    }

    public void removeAllItems() {
        this.mLec.removeAllItems();
    }

    @Override
    public void updateUI() {
        if (this.mLec != null) {
            this.mLec.updateUI();
        }
        super.updateUI();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mLec.setEnabled(enabled);
        this.mVer.setEnabled(enabled);
    }

    public Integer getEntryVersion() {
        if (this.mVer.getSelectedIndex() == -1) {
            return null;
        }
        return this.mVer.getItemAt(this.mVer.getSelectedIndex());
    }
}

