/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.instance;

import java.awt.Graphics2D;
import org.cristalise.gui.graph.view.DirectedEdgeRenderer;
import org.cristalise.gui.graph.view.GraphPanel;
import org.cristalise.gui.graph.view.VertexRenderer;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.lifecycle.instance.Next;

public class WfGraphPanel
extends GraphPanel {
    public WfGraphPanel(DirectedEdgeRenderer d, VertexRenderer v) {
        super(d, v);
    }

    @Override
    protected void drawEdgeHighlight(Graphics2D g2d, DirectedEdge edge) {
        boolean arrowOnY;
        GraphPoint originPoint = edge.getOriginPoint();
        GraphPoint terminusPoint = edge.getTerminusPoint();
        GraphPoint midPoint = new GraphPoint();
        if ("Straight".equals(((Next)edge).getProperties().get((Object)"Type")) || ((Next)edge).getProperties().get((Object)"Type") == null) {
            midPoint.x = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
            midPoint.y = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
        } else if ("Broken +".equals(((Next)edge).getProperties().get((Object)"Type"))) {
            midPoint.x = (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = (originPoint.y + terminusPoint.y) / 2;
        } else if ("Broken -".equals(((Next)edge).getProperties().get((Object)"Type"))) {
            arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
            midPoint.x = arrowOnY ? terminusPoint.x : (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : originPoint.y;
        } else if ("Broken |".equals(((Next)edge).getProperties().get((Object)"Type"))) {
            arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
            midPoint.x = arrowOnY ? originPoint.x : (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : terminusPoint.y;
        }
        int minX = midPoint.x - 10;
        int minY = midPoint.y - 10;
        int maxX = midPoint.x + 10;
        int maxY = midPoint.y + 10;
        g2d.drawLine(minX, minY, maxX, minY);
        g2d.drawLine(maxX, minY, maxX, maxY);
        g2d.drawLine(maxX, maxY, minX, maxY);
        g2d.drawLine(minX, maxY, minX, minY);
    }
}

