/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.collection;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.collection.AggregationMemberRenderer;
import org.cristalise.gui.collection.PropertyPanel;
import org.cristalise.gui.collection.SelectedMemberPanel;
import org.cristalise.gui.graph.view.EditorPanel;
import org.cristalise.gui.graph.view.GraphPanel;
import org.cristalise.gui.tabs.collection.CollectionHistoryWindow;
import org.cristalise.gui.tabs.collection.CollectionView;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.AggregationVertexFactory;
import org.cristalise.kernel.collection.AggregationVertexOutlineCreator;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.graph.model.VertexFactory;
import org.cristalise.kernel.graph.model.VertexOutlineCreator;

public class AggregationView
extends CollectionView<AggregationMember> {
    protected JButton mSaveButton = new JButton(ImageLoader.findImage("graph/save.png"));
    protected JButton mHistoryButton = new JButton(ImageLoader.findImage("graph/history.png"));
    protected JButton[] mOtherToolBarButtons = new JButton[]{this.mSaveButton, this.mHistoryButton};
    protected EditorPanel mEditorPanel;
    protected PropertyPanel mPropertyPanel;
    protected JSplitPane mSplitPane;
    private final AggregationVertexFactory mAggregationVertexFactory = new AggregationVertexFactory();
    private final AggregationMemberRenderer mAggregationMemberRenderer = new AggregationMemberRenderer();

    public AggregationView() {
        this.setLayout(new GridLayout(1, 1));
        this.mPropertyPanel = new PropertyPanel();
        this.mEditorPanel = new EditorPanel(null, (VertexFactory)this.mAggregationVertexFactory, (VertexOutlineCreator)new AggregationVertexOutlineCreator(), false, this.mOtherToolBarButtons, new GraphPanel(null, this.mAggregationMemberRenderer));
        this.createLayout();
        this.createListeners();
        this.mPropertyPanel.setGraphModelManager(this.mEditorPanel.mGraphModelManager);
        this.mPropertyPanel.createLayout(new SelectedMemberPanel());
        this.mEditorPanel.setEditable(MainFrame.isAdmin);
    }

    @Override
    public void setCollection(Collection<AggregationMember> contents) {
        this.thisColl = contents;
        Aggregation agg = (Aggregation)this.thisColl;
        this.mPropertyPanel.setCollection(agg);
        this.mAggregationMemberRenderer.setAggregation(agg);
        this.mEditorPanel.mGraphModelManager.setModel(agg.getLayout());
        this.mEditorPanel.updateVertexTypes(agg.getVertexTypeNameAndConstructionInfo());
        this.mEditorPanel.enterSelectMode();
        this.mAggregationVertexFactory.setCreationContext((Object)agg);
    }

    public void createLayout() {
        this.mSaveButton.setToolTipText("Save Layout Changes");
        this.mSplitPane = new JSplitPane(1, this.mEditorPanel, this.mPropertyPanel);
        this.mSplitPane.setDividerSize(5);
        this.add(this.mSplitPane);
    }

    protected void createListeners() {
        this.mSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AggregationView.this.saveCollection();
            }
        });
        this.mHistoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new CollectionHistoryWindow(AggregationView.this.item, (Aggregation)AggregationView.this.thisColl);
            }
        });
    }
}

