/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.cristalise.gui.tabs.outcome.form.field.ArrayTableModel;
import org.cristalise.gui.tabs.outcome.form.field.EditField;
import org.exolab.castor.xml.schema.SimpleType;

public class ArrayEditField
extends EditField
implements ActionListener {
    Box arrayBox;
    Box expandBox;
    Box editBox;
    JScrollPane arrayView;
    JButton arrayButton;
    JButton expandButton;
    JButton contractButton;
    JButton addButton;
    JButton removeButton;
    ArrayTableModel arrayModel;
    JLabel arrayLabel = new JLabel("Array");
    boolean panelShown = false;
    boolean readOnly = false;

    public ArrayEditField(SimpleType type) {
        this.arrayBox = Box.createVerticalBox();
        this.arrayBox.add(this.arrayLabel);
        this.arrayButton = new JButton("Show");
        this.arrayButton.addActionListener(this);
        this.arrayButton.setActionCommand("toggle");
        this.arrayBox.add(this.arrayButton);
        this.expandBox = Box.createHorizontalBox();
        this.expandButton = new JButton(">>");
        this.expandButton.setToolTipText("Increase the number of columns displaying this array");
        this.expandButton.addActionListener(this);
        this.expandButton.setActionCommand("extend");
        this.contractButton = new JButton("<<");
        this.contractButton.setToolTipText("Decrease the number of columns displaying this array");
        this.contractButton.addActionListener(this);
        this.contractButton.setActionCommand("contract");
        this.expandBox.add(this.contractButton);
        this.expandBox.add(Box.createHorizontalGlue());
        this.expandBox.add(this.expandButton);
        this.arrayModel = new ArrayTableModel(type);
        if (this.arrayModel.getColumnCount() < 2) {
            this.contractButton.setEnabled(false);
        }
        this.arrayView = new JScrollPane(new JTable(this.arrayModel));
        this.editBox = Box.createHorizontalBox();
        this.addButton = new JButton("+");
        this.addButton.setToolTipText("Add a field to the end of this array");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("add");
        this.removeButton = new JButton("-");
        this.removeButton.setToolTipText("Remove the last field from this array");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("remove");
        this.editBox.add(this.addButton);
        this.editBox.add(Box.createHorizontalGlue());
        this.editBox.add(this.removeButton);
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    public String getText() {
        return this.arrayModel.getData();
    }

    @Override
    public void setText(String text) {
        this.arrayModel.setData(text);
        this.arrayLabel.setText("Array (" + this.arrayModel.getArrayLength() + " values)");
    }

    @Override
    public Component getControl() {
        return this.arrayBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("toggle")) {
            this.arrayBox.removeAll();
            if (this.panelShown) {
                this.arrayBox.add(this.arrayLabel);
                this.arrayBox.add(Box.createVerticalStrut(7));
                this.arrayBox.add(this.arrayButton);
                this.arrayButton.setText("Show");
            } else {
                this.arrayBox.add(this.arrayLabel);
                this.arrayBox.add(Box.createVerticalStrut(7));
                this.arrayBox.add(this.arrayButton);
                this.arrayBox.add(Box.createVerticalStrut(7));
                this.arrayBox.add(this.expandBox);
                this.arrayBox.add(Box.createVerticalStrut(7));
                this.arrayBox.add(this.arrayView);
                if (!this.readOnly) {
                    this.arrayBox.add(this.editBox);
                }
                this.arrayButton.setText("Hide");
            }
            this.panelShown = !this.panelShown;
            this.arrayBox.validate();
        } else if (e.getActionCommand().equals("add")) {
            this.arrayModel.addField();
            this.arrayLabel.setText("Array (" + this.arrayModel.getArrayLength() + " values)");
        } else if (e.getActionCommand().equals("remove")) {
            this.arrayModel.removeField();
            this.arrayLabel.setText("Array (" + this.arrayModel.getArrayLength() + " values)");
        } else {
            int currentCols = this.arrayModel.getColumnCount();
            if (e.getActionCommand().equals("extend")) {
                ++currentCols;
            } else if (e.getActionCommand().equals("contract")) {
                --currentCols;
            }
            this.arrayModel.setColumnCount(currentCols);
            this.contractButton.setEnabled(currentCols > 1);
        }
    }

    @Override
    public JTextComponent makeTextField() {
        return null;
    }

    @Override
    public void setEditable(boolean editable) {
        this.readOnly = !editable;
        this.arrayModel.setReadOnly(!this.readOnly);
    }
}

