/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.utils.Logger;

public class ItemDetails
extends JPanel
implements ChangeListener,
Runnable {
    protected JTabbedPane myTabbedPane = new JTabbedPane(1);
    protected JPanel itemTitlePanel;
    private ItemTabManager desktopManager;
    protected NodeItem myItem;
    protected HashMap<ItemTabPane, Boolean> childPanes = new HashMap();
    protected String startTab = MainFrame.getPref("DefaultStartTab", "Properties");
    protected String startCommand = null;
    protected boolean initialized = false;

    public ItemDetails(NodeItem thisItem) {
        this.myItem = thisItem;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Entity Pane Builder");
        ItemTabPane componentToAdd = null;
        this.setLayout(new BorderLayout());
        this.itemTitlePanel = this.getItemTitlePanel();
        this.add((Component)this.itemTitlePanel, "North");
        this.add(this.myTabbedPane);
        ArrayList<String> requiredTabs = this.myItem.getTabs();
        for (String name2 : requiredTabs) {
            String tabName = name2;
            if (tabName == null) continue;
            Class<?> myClass = null;
            try {
                myClass = Class.forName(this.getClass().getPackage().getName() + ".tabs." + tabName + "Pane");
                Logger.msg((int)2, (String)("ItemDetails.<init> - Creating ItemTabPane instance: " + this.getClass().getPackage().getName() + ".tabs." + tabName + "Pane"), (Object[])new Object[0]);
                componentToAdd = (ItemTabPane)myClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                Logger.msg((int)2, (String)("ItemDetails.<init> - No specialist tab found for " + tabName + ". Using default."), (Object[])new Object[0]);
            }
            catch (InstantiationException e) {
                Logger.msg((int)0, (String)("ItemDetails.<init> - Instantiation Error! " + e), (Object[])new Object[0]);
            }
            catch (IllegalAccessException e) {
                Logger.msg((int)0, (String)("ItemDetails.<init> - Illegal Method Access Error! Class was probably not a ItemTabPane: " + e), (Object[])new Object[0]);
            }
            if (componentToAdd == null) {
                componentToAdd = new ItemTabPane(tabName, null);
            }
            componentToAdd.setParent(this);
            this.childPanes.put(componentToAdd, new Boolean(false));
            int placement = this.myTabbedPane.getTabCount();
            if (tabName.equals("Properties")) {
                placement = 0;
            }
            this.myTabbedPane.insertTab(componentToAdd.getTabName(), null, componentToAdd, null, placement);
        }
        this.initialized = true;
        if (!requiredTabs.contains(this.startTab)) {
            this.startTab = "Properties";
            this.startCommand = null;
        }
        this.runCommand(this.startTab, this.startCommand);
        this.myTabbedPane.setVisible(true);
        this.myTabbedPane.addChangeListener(this);
        this.validate();
        MainFrame.progress.stopBouncing("Done");
    }

    @Override
    public void stateChanged(ChangeEvent p1) {
        this.initialisePane((ItemTabPane)this.myTabbedPane.getSelectedComponent());
    }

    public void initialisePane(ItemTabPane pane) {
        Boolean isInit = this.childPanes.get(pane);
        if (!isInit.booleanValue()) {
            Logger.msg((int)4, (String)("Initialising " + pane.getTabName()), (Object[])new Object[0]);
            pane.initForItem(this.myItem);
            this.childPanes.put(pane, new Boolean(true));
            this.validate();
        }
    }

    public ItemTabManager getDesktopManager() {
        return this.desktopManager;
    }

    public void setDesktopManager(ItemTabManager newDesktopManager) {
        this.desktopManager = newDesktopManager;
    }

    public JPanel getItemTitlePanel() {
        JPanel titlePanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        titlePanel.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 0;
        c.anchor = 11;
        c.ipadx = 5;
        c.ipady = 5;
        ImageIcon icon = ImageLoader.findImage("typeicons/" + this.myItem.getIconName() + "_32.png");
        if (icon == ImageLoader.nullImg) {
            icon = ImageLoader.findImage("typeicons/item_32.png");
        }
        JLabel current = new JLabel(icon);
        gridbag.setConstraints(current, c);
        titlePanel.add(current);
        current = new JLabel(this.myItem.getName() + " (" + this.myItem.getItemPath().getUUID().toString() + ")");
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 1;
        c.anchor = 11;
        c.fill = 2;
        c.weightx = 1.0;
        c.ipadx = 2;
        c.ipady = 2;
        current.setFont(new Font("Helvetica", 0, 18));
        gridbag.setConstraints(current, c);
        titlePanel.add(current);
        current = new JLabel(this.myItem.getType());
        c.gridx = 1;
        c.gridy = 2;
        c.gridheight = 1;
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        current.setFont(new Font("Helvetica", 0, 12));
        gridbag.setConstraints(current, c);
        titlePanel.add(current);
        return titlePanel;
    }

    public void discardTabs() {
        this.myTabbedPane.removeChangeListener(this);
        this.myTabbedPane.removeAll();
        Iterator<ItemTabPane> iter = this.childPanes.keySet().iterator();
        while (iter.hasNext()) {
            ItemTabPane element = iter.next();
            element.destroy();
            iter.remove();
        }
    }

    public ItemPath getItemPath() {
        return this.myItem.getItemPath();
    }

    public void closeTab() {
        this.desktopManager.remove(this.myItem.getItemPath());
        Logger.msg((int)5, (String)("Remove master Tab :" + this.myItem.getType() + " SysKey " + this.myItem.getItemPath()), (Object[])new Object[0]);
        this.myItem.getItem().dumpSubscriptions(5);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("close")) {
            this.closeTab();
        }
    }

    public void runCommand(String tab, String command) {
        if (this.initialized) {
            int tabIndex = this.findTab(tab);
            Logger.msg((int)3, (String)("Running command " + tab + " " + command + " (" + tabIndex + ")"), (Object[])new Object[0]);
            if (tabIndex == -1) {
                Logger.error((String)("Tab " + tab + " not found for command " + command), (Object[])new Object[0]);
                return;
            }
            ItemTabPane startPane = (ItemTabPane)this.myTabbedPane.getComponentAt(tabIndex);
            this.myTabbedPane.setSelectedIndex(tabIndex);
            this.initialisePane(startPane);
            if (command != null) {
                startPane.runCommand(command);
            }
        } else {
            Logger.msg((int)3, (String)("Storing command " + tab + " " + command + " until initialised."), (Object[])new Object[0]);
            this.startTab = tab;
            this.startCommand = command;
        }
    }

    protected int findTab(String tabName) {
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            ItemTabPane thisPane = (ItemTabPane)this.myTabbedPane.getComponentAt(i);
            if (!thisPane.getTabName().equals(tabName)) continue;
            return i;
        }
        return -1;
    }

    public void refresh() {
    }

    protected void finalize() throws Throwable {
        Logger.msg((int)7, (String)("EntityDetails " + this.myItem.getItemPath() + " reaped"), (Object[])new Object[0]);
        super.finalize();
    }
}

