/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.controller;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.graph.view.EditorModeListener;
import org.cristalise.gui.graph.view.EditorToolBar;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.GraphPoint;

public class VertexConstructionController
extends MouseAdapter
implements EditorModeListener {
    private GraphModelManager mGraphModelManager = null;
    private EditorToolBar mEditorToolBar = null;
    private boolean mCreatingVertices = false;

    public void setGraphModelManager(GraphModelManager graphModelManager) {
        this.mGraphModelManager = graphModelManager;
    }

    public void setEditorToolBar(EditorToolBar editorToolBar) {
        this.mEditorToolBar = editorToolBar;
        this.mEditorToolBar.addEditorModeListener(this);
    }

    @Override
    public void editorModeChanged(String idOfNewMode) {
        this.mCreatingVertices = idOfNewMode.equals("Vertex");
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (this.mCreatingVertices && this.mGraphModelManager != null && this.mEditorToolBar != null && this.mGraphModelManager.isEditable()) {
            try {
                this.mGraphModelManager.getModel().createVertex(new GraphPoint(me.getPoint().x, me.getPoint().y), this.mEditorToolBar.getSelectedVertexType());
            }
            catch (Exception e) {
                MainFrame.exceptionDialog(e);
            }
            this.mEditorToolBar.enterSelectMode();
        }
    }
}

