/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.ItemFinder;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.LoginBox;
import org.cristalise.gui.MenuBuilder;
import org.cristalise.gui.ProgressReporter;
import org.cristalise.gui.TreeBrowser;
import org.cristalise.gui.tabs.execution.DefaultExecutor;
import org.cristalise.gui.tabs.execution.Executor;
import org.cristalise.gui.tree.NodeContext;
import org.cristalise.gui.tree.NodeRole;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;

public class MainFrame
extends JFrame {
    public static TreeBrowser domBrowser;
    public static TreeBrowser roleBrowser;
    public static ItemTabManager myDesktopManager;
    public static ItemFinder itemFinder;
    protected MenuBuilder menuBuilder;
    protected ORB orb;
    public static Properties prefs;
    public static ProgressReporter progress;
    public String logoURL;
    public static AgentProxy userAgent;
    protected JSplitPane splitPane;
    private JTabbedPane treePanel;
    public static boolean isAdmin;
    int splitPanePos;
    public static final JFileChooser xmlChooser;

    public MainFrame() {
        try {
            FileInputStream prefsfile = new FileInputStream("cristal.preferences");
            prefs.load(prefsfile);
            prefsfile.close();
        }
        catch (IOException e) {
            Logger.msg((int)2, (String)"Creating new preference file", (Object[])new Object[0]);
        }
        try {
            String lf = MainFrame.getPref("Style", null);
            if (lf == null) {
                lf = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showLogin() {
        this.logoURL = Gateway.getProperties().getString("Logo");
        String bottomMessage = "Please enter username & password";
        ImageIcon imageHolder = new ImageIcon("");
        try {
            URL pictureUrl = new URL(this.logoURL);
            imageHolder = new ImageIcon(pictureUrl);
        }
        catch (MalformedURLException m) {
            imageHolder = ImageLoader.findImage(this.logoURL);
        }
        LoginBox login = new LoginBox(5, Gateway.getProperties().getString("Name"), MainFrame.getPref("lastUser." + Gateway.getCentreId(), null), bottomMessage, imageHolder, this);
        login.setVisible(true);
    }

    public void mainFrameShow() {
        String panePos;
        prefs.setProperty("lastUser." + Gateway.getCentreId(), userAgent.getName());
        isAdmin = userAgent.getPath().hasRole("Admin");
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        this.setTitle(userAgent.getName() + "@" + Gateway.getProperties().getString("Name") + " - Cristal");
        String iconFile = Gateway.getProperties().getString("AppIcon");
        if (iconFile != null) {
            this.setIconImage(ImageLoader.findImage(iconFile).getImage());
        }
        ImageLoader.findImage("loading.gif");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.exitForm();
            }
        });
        myDesktopManager = new ItemTabManager();
        this.menuBuilder = new MenuBuilder(this);
        this.setJMenuBar(this.menuBuilder);
        myDesktopManager.setMenuBuilder(this.menuBuilder);
        this.treePanel = new JTabbedPane(1);
        NodeContext userNode = new NodeContext((Path)new DomainPath(""), myDesktopManager);
        domBrowser = new TreeBrowser(myDesktopManager, userNode);
        NodeRole roleNode = new NodeRole((Path)new RolePath(), myDesktopManager);
        roleBrowser = new TreeBrowser(myDesktopManager, roleNode);
        this.treePanel.add("Domain", domBrowser);
        this.treePanel.add("Roles", roleBrowser);
        this.treePanel.setVisible(MainFrame.getPref("ShowTree", "true").equals("true"));
        itemFinder = new ItemFinder();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        gridbag.setConstraints(itemFinder, c);
        this.getContentPane().add(itemFinder);
        itemFinder.setDefaultConsumer(domBrowser);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        gridbag.setConstraints(this.getSplitPanel(), c);
        this.getContentPane().add(this.getSplitPanel());
        progress = new ProgressReporter();
        ++c.gridy;
        c.weighty = 0.0;
        gridbag.setConstraints(progress, c);
        this.getContentPane().add(progress);
        this.pack();
        String paneSize = MainFrame.getPref("WindowSize", null);
        if (paneSize != null) {
            StringTokenizer tok = new StringTokenizer(paneSize, ",");
            Dimension window = new Dimension();
            window.setSize(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
            this.setSize(window);
        }
        if ((panePos = MainFrame.getPref("WindowPosition", null)) != null) {
            StringTokenizer tok = new StringTokenizer(panePos, ",");
            Point window = new Point(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
            this.setLocation(window);
        }
        super.toFront();
        this.validate();
        this.setVisible(true);
    }

    public static String getPref(String name, String defaultValue) {
        return prefs.getProperty(name, defaultValue);
    }

    public static void setPref(String name, String value) {
        prefs.setProperty(name, value);
    }

    public void exitForm() {
        MainFrame.setPref("WindowSize", (int)this.getSize().getWidth() + "," + (int)this.getSize().getHeight());
        MainFrame.setPref("WindowPosition", (int)this.getLocation().getX() + "," + (int)this.getLocation().getY());
        MainFrame.setPref("Style", UIManager.getLookAndFeel().getClass().getName());
        MainFrame.setPref("SplitPanePosition", String.valueOf(this.splitPane.getDividerLocation()));
        try {
            FileOutputStream prefsfile = new FileOutputStream("cristal.preferences", false);
            prefs.store(prefsfile, "Cristal 2");
            prefsfile.close();
        }
        catch (Exception e) {
            Logger.warning((String)"Could not write to preferences file. Preferences have not been updated.", (Object[])new Object[0]);
        }
        this.dispose();
        AbstractMain.shutdown((int)0);
    }

    public void toggleTree() {
        boolean showTree = MainFrame.getPref("ShowTree", "true").equals("false");
        MainFrame.setPref("ShowTree", String.valueOf(showTree));
        if (!showTree) {
            this.splitPanePos = this.splitPane.getDividerLocation();
        }
        this.getSplitPanel().getLeftComponent().setVisible(showTree);
        if (showTree) {
            this.getSplitPanel().setDividerLocation(this.splitPanePos);
        }
        this.getSplitPanel().validate();
    }

    public static JComboBox<Executor> getExecutionPlugins() {
        JComboBox<Executor> plugins = new JComboBox<Executor>();
        DefaultExecutor defaultExecutor = new DefaultExecutor();
        plugins.addItem(defaultExecutor);
        plugins.setSelectedIndex(0);
        String pluginList = Gateway.getProperties().getString("Executors");
        if (pluginList != null) {
            StringTokenizer tok = new StringTokenizer(pluginList, ",");
            while (tok.hasMoreTokens()) {
                String pluginName = tok.nextToken();
                try {
                    Class<?> pluginClass = Class.forName(pluginName);
                    Executor domainExecutor = (Executor)pluginClass.newInstance();
                    plugins.addItem(domainExecutor);
                }
                catch (Exception ex) {
                    Logger.error((String)("Could not load the executor plugin " + pluginName), (Object[])new Object[0]);
                }
            }
        }
        return plugins;
    }

    protected JSplitPane getSplitPanel() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(1, true, this.treePanel, myDesktopManager);
            this.splitPane.setDividerSize(5);
            this.splitPanePos = Integer.parseInt(MainFrame.getPref("SplitPanePosition", "200"));
            this.splitPane.setDividerLocation(this.splitPanePos);
        }
        return this.splitPane;
    }

    public static void exceptionDialog(Exception ex) {
        Logger.error((Throwable)ex);
        String className = ex.getClass().getSimpleName();
        String error = ex.getMessage();
        if (ex instanceof UserException) {
            error = error.substring(error.indexOf(32) + 1);
        }
        JOptionPane.showMessageDialog(null, error, className, 0);
    }

    static {
        prefs = new Properties();
        xmlChooser = new JFileChooser();
        xmlChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML Files";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().endsWith(".xml");
            }
        });
    }
}

