/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.lifecycle.desc;

import java.util.HashMap;
import javax.swing.JOptionPane;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.lifecycle.chooser.ActivityChooser;
import org.cristalise.gui.lifecycle.chooser.WorkflowDialogue;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.graph.model.VertexFactory;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class WfVertexDefFactory
implements VertexFactory,
WorkflowDialogue {
    protected CompositeActivityDef mCompositeActivityDef = null;

    public void create(GraphModelManager graphModelManager, GraphPoint location, TypeNameAndConstructionInfo typeNameAndConstructionInfo) throws ObjectNotFoundException, InvalidDataException {
        String vertexTypeId = null;
        if (this.mCompositeActivityDef != null && typeNameAndConstructionInfo.mInfo instanceof String) {
            vertexTypeId = (String)typeNameAndConstructionInfo.mInfo;
            if (vertexTypeId.equals("Atomic") || vertexTypeId.equals("Composite")) {
                HashMap<String, Object> mhm = new HashMap<String, Object>();
                mhm.put("P1", vertexTypeId);
                mhm.put("P2", location);
                ActivityChooser a = new ActivityChooser(vertexTypeId, ImageLoader.findImage("graph/newvertex_large.png").getImage(), this, mhm);
                a.setVisible(true);
            } else {
                String localName = "";
                if (vertexTypeId.equals("AtomicLocal") || vertexTypeId.equals("CompositeLocal")) {
                    localName = this.promptName(vertexTypeId);
                }
                this.mCompositeActivityDef.newChild(localName, vertexTypeId, null, location);
            }
        }
    }

    @Override
    public void loadThisWorkflow(String newName, Integer version, HashMap<String, Object> hashMap) throws ObjectNotFoundException, InvalidDataException {
        ActivityDef act;
        String vertexTypeId = (String)hashMap.get("P1");
        GraphPoint location = (GraphPoint)hashMap.get("P2");
        if (newName == null || newName.equals("")) {
            return;
        }
        Logger.debug((int)5, (String)newName, (Object[])new Object[0]);
        try {
            act = LocalObjectLoader.getActDef((String)newName, (int)(version == null ? 0 : version));
        }
        catch (Exception ex) {
            MainFrame.exceptionDialog(ex);
            return;
        }
        WfVertexDef slot = (WfVertexDef)this.mCompositeActivityDef.search(this.mCompositeActivityDef.getID() + "/" + newName);
        if (slot != null) {
            while ((newName = this.promptName(vertexTypeId)) == null || newName.length() == 0 || this.mCompositeActivityDef.search(this.mCompositeActivityDef.getID() + "/" + newName) != null) {
            }
            slot = this.mCompositeActivityDef.addExistingActivityDef(newName, act, location);
        } else {
            slot = this.mCompositeActivityDef.newChild(newName, vertexTypeId, version, location);
        }
        for (String propName : act.getProperties().getAbstract()) {
            slot.getProperties().put((Object)propName, act.getProperties().get((Object)propName));
        }
    }

    public void setCreationContext(Object newContext) {
        if (newContext != null && newContext instanceof CompositeActivityDef) {
            this.mCompositeActivityDef = (CompositeActivityDef)newContext;
        }
    }

    public String promptName(String type) {
        return (String)JOptionPane.showInputDialog(null, "Please provide a unique name for this instance of the activity", "New " + type + " Activity Instance", 3, ImageLoader.findImage("graph/newvertex_large.png"), null, null);
    }
}

