/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.MainFrame;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;

public class DomainPathAdmin
extends Box
implements ActionListener {
    ItemProxy entity;
    JTable table;
    DomainPathTableModel model = new DomainPathTableModel(this);
    JButton addButton;
    JButton removeButton;

    public DomainPathAdmin() {
        super(1);
        this.table = new JTable(this.model);
        this.add(new JScrollPane(this.table));
        this.add(Box.createVerticalGlue());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        this.addButton = new JButton("Add");
        buttonBox.add(this.addButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.removeButton = new JButton("Remove");
        buttonBox.add(this.removeButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.add(buttonBox);
        this.addButton.setActionCommand("add");
        this.addButton.addActionListener(this);
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(this);
    }

    public void setEntity(ItemProxy entity) {
        this.entity = entity;
        this.model.loadPaths();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("add")) {
            String newPath = JOptionPane.showInputDialog(this, "Enter new path,", "Add Domain Path", -1);
            this.addDomainPath(new DomainPath(newPath));
            this.model.loadPaths();
        } else if (e.getActionCommand().equals("remove") && this.table.getSelectedRow() > -1) {
            DomainPath oldPath = this.model.getPath(this.table.getSelectedRow());
            this.removeDomainPath(oldPath);
            this.model.loadPaths();
        }
    }

    public boolean removeDomainPath(DomainPath oldPath) {
        return this.alterDomainPath(oldPath, "Remove");
    }

    public boolean addDomainPath(DomainPath newPath) {
        return this.alterDomainPath(newPath, "Add");
    }

    public boolean alterDomainPath(DomainPath path, String action) {
        if (JOptionPane.showConfirmDialog(this, action + " " + path + "?", action + " Domain Path", 0) != 0) {
            return false;
        }
        String[] params = new String[]{path.toString()};
        try {
            MainFrame.userAgent.execute(this.entity, action + "DomainPath", params);
        }
        catch (Exception e) {
            MainFrame.exceptionDialog(e);
            return false;
        }
        return true;
    }

    private class DomainPathTableModel
    extends AbstractTableModel {
        ArrayList<DomainPath> domPaths;
        DomainPathAdmin parent;

        public DomainPathTableModel(DomainPathAdmin parent) {
            this.parent = parent;
            this.domPaths = new ArrayList();
        }

        public void loadPaths() {
            this.domPaths.clear();
            Iterator currentPaths = Gateway.getLookup().searchAliases(DomainPathAdmin.this.entity.getPath());
            while (currentPaths.hasNext()) {
                this.domPaths.add((DomainPath)currentPaths.next());
            }
            this.fireTableDataChanged();
        }

        public DomainPath getPath(int rowIndex) {
            return this.domPaths.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DomainPath oldPath = this.domPaths.get(rowIndex);
            DomainPath newPath = new DomainPath((String)aValue);
            boolean success = this.parent.addDomainPath(newPath);
            if (success) {
                success = this.parent.removeDomainPath(oldPath);
            }
            if (success) {
                oldPath.setPath((Path)newPath);
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "Path";
        }

        @Override
        public int getRowCount() {
            return this.domPaths.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.domPaths.get(rowIndex).toString();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }
}

