/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.Logger;

public class JobListPane
extends ItemTabPane
implements ActionListener,
ProxyObserver<Job> {
    JobList joblist;
    JoblistTableModel model;
    JTable eventTable;
    JButton startButton = new JButton("<<");
    JButton prevButton = new JButton("<");
    JButton nextButton = new JButton(">");
    JButton endButton = new JButton(">>");
    public static final int SIZE = 30;
    int currentSize = 30;

    public JobListPane() {
        super("Job List", "Agent Job List");
        this.initPanel();
        Box navBox = Box.createHorizontalBox();
        navBox.add(this.startButton);
        navBox.add(this.prevButton);
        navBox.add(this.nextButton);
        navBox.add(this.endButton);
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.prevButton.setActionCommand("prev");
        this.prevButton.addActionListener(this);
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        this.endButton.setActionCommand("end");
        this.endButton.addActionListener(this);
        this.add(navBox);
        this.add(Box.createVerticalStrut(5));
        this.eventTable = new JTable();
        JScrollPane eventScroll = new JScrollPane(this.eventTable);
        this.add(eventScroll);
        this.eventTable.addMouseListener(new JobListMouseListener());
    }

    @Override
    public void reload() {
        this.joblist.clear();
        this.jumpToEnd();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Joblist Pane Builder");
        try {
            this.joblist = (JobList)this.sourceItem.getItem().getObject(ClusterStorage.JOB);
            this.joblist.activate();
            this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, ClusterStorage.JOB, false));
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
        }
        this.model = new JoblistTableModel(this.joblist);
        this.eventTable.setModel(this.model);
        this.jumpToEnd();
    }

    public void jumpToEnd() {
        int lastEvent = this.joblist.getLastId();
        int firstEvent = 0;
        this.currentSize = 30;
        if (lastEvent > this.currentSize) {
            firstEvent = lastEvent - this.currentSize + 1;
        }
        if (lastEvent < this.currentSize) {
            this.currentSize = lastEvent + 1;
        }
        Logger.msg((int)5, (String)("JobListPane.run() - init table start " + firstEvent + " for " + this.currentSize), (Object[])new Object[0]);
        this.model.setView(firstEvent, this.currentSize);
    }

    public void add(Job contents) {
        this.reload();
    }

    public void remove(String id) {
        this.reload();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("end")) {
            this.jumpToEnd();
            return;
        }
        int lastEvent = this.joblist.getLastId();
        int startEvent = this.model.getStartId();
        if (e.getActionCommand().equals("start")) {
            this.currentSize = 30;
            startEvent = 0;
        } else if (e.getActionCommand().equals("prev")) {
            this.currentSize = 30;
            if ((startEvent -= this.currentSize) < 0) {
                startEvent = 0;
            }
        } else if (e.getActionCommand().equals("next")) {
            this.currentSize = 30;
            if ((startEvent += this.currentSize) > lastEvent) {
                startEvent = lastEvent - this.currentSize + 1;
            }
        } else {
            return;
        }
        this.model.setView(startEvent, this.currentSize);
    }

    public void control(String control, String msg) {
    }

    private class JobListMouseListener
    extends MouseAdapter {
        private JobListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() == 2) {
                Job selectedJob = JobListPane.this.model.getJobAtRow(JobListPane.this.eventTable.getSelectedRow());
                try {
                    MainFrame.itemFinder.pushNewKey(selectedJob.getItemProxy().getName());
                }
                catch (Exception ex) {
                    Logger.error((Throwable)ex);
                    JOptionPane.showMessageDialog(null, "No Item Found", "Job references an unknown item", 0);
                }
            }
        }
    }

    private class JoblistTableModel
    extends AbstractTableModel {
        Job[] job = new Job[0];
        Integer[] ids = new Integer[0];
        String[] itemNames;
        int loaded = 0;
        int startId = 0;

        public JoblistTableModel(JobList joblist) {
        }

        public int getStartId() {
            return this.startId;
        }

        public void setView(int startId, int size) {
            this.job = new Job[size];
            this.ids = new Integer[size];
            this.itemNames = new String[size];
            this.startId = startId;
            int count = 0;
            Iterator i = JobListPane.this.joblist.keySet().iterator();
            while (i.hasNext()) {
                Integer thisJobId = new Integer((String)i.next());
                if (count >= startId) {
                    int idx = count - startId;
                    this.ids[idx] = thisJobId;
                    this.job[idx] = JobListPane.this.joblist.getJob(thisJobId.intValue());
                    this.itemNames[idx] = "Item Not Found";
                    try {
                        this.itemNames[idx] = ((Property)Gateway.getStorage().get(this.job[count - startId].getItemPath(), ClusterStorage.PROPERTY + "/Name", null)).getValue();
                    }
                    catch (Exception ex) {
                        Logger.error((Throwable)ex);
                    }
                }
                this.loaded = ++count - startId;
                if (count <= startId + size) continue;
                break;
            }
            this.fireTableStructureChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "Subject";
                }
                case 2: {
                    return "Activity";
                }
                case 3: {
                    return "Transition";
                }
                case 4: {
                    return "Date";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.loaded;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.job.length <= rowIndex || this.job[rowIndex] == null) {
                return "";
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return this.ids[rowIndex];
                    }
                    case 1: {
                        return this.itemNames[rowIndex];
                    }
                    case 2: {
                        return this.job[rowIndex].getStepName();
                    }
                    case 3: {
                        return this.job[rowIndex].getTransition().getName();
                    }
                    case 4: {
                        return DateUtility.timeToString((GTimeStamp)this.job[rowIndex].getCreationDate());
                    }
                }
                return "";
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Job getJobAtRow(int rowIndex) {
            return this.job[rowIndex];
        }
    }
}

