/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.collection;

import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.collection.AggregationView;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class CollectionHistoryWindow
extends JFrame {
    JTable historyTable;
    HistoryTableModel historyModel;

    public CollectionHistoryWindow(ItemProxy item, Aggregation coll) throws HeadlessException {
        super("Collection History");
        this.setDefaultCloseOperation(2);
        this.historyModel = new HistoryTableModel(item, coll);
        this.historyTable = new JTable(this.historyModel);
        this.getContentPane().add(new JScrollPane(this.historyTable));
        this.historyTable.addMouseListener(new HistoryTableListener(item));
        this.pack();
        super.toFront();
        this.validate();
        this.setVisible(true);
    }

    private class HistoryTableListener
    extends MouseAdapter {
        ItemProxy item;

        public HistoryTableListener(ItemProxy item) {
            this.item = item;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = CollectionHistoryWindow.this.historyTable.getSelectedRow();
                Object data = CollectionHistoryWindow.this.historyModel.getEventData(row);
                if (data instanceof Aggregation) {
                    this.showColl((Aggregation)data);
                } else {
                    String[] params = (String[])data;
                    try {
                        ItemProxy childItem = Gateway.getProxyManager().getProxy((Path)new ItemPath(params[2]));
                        MainFrame.itemFinder.pushNewKey(childItem.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void showColl(Aggregation coll) {
            JFrame newFrame = new JFrame();
            AggregationView newView = new AggregationView();
            newView.setCollection((Collection<AggregationMember>)coll);
            newView.setItem(this.item);
            newFrame.getContentPane().add(newView);
            newFrame.pack();
            newFrame.toFront();
            newFrame.validate();
            newFrame.setVisible(true);
        }
    }

    private class HistoryTableModel
    extends AbstractTableModel
    implements ProxyObserver<Event> {
        ItemProxy item;
        ArrayList<Event> collEvents;
        ArrayList<Object> collEventData;
        Aggregation coll;

        public HistoryTableModel(ItemProxy item, Aggregation coll) {
            this.item = item;
            this.coll = coll;
            this.collEvents = new ArrayList();
            this.collEventData = new ArrayList();
            item.subscribe(new MemberSubscription((ProxyObserver)this, ClusterStorage.HISTORY, true));
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Date";
                }
                case 1: {
                    return "Operation";
                }
                case 2: {
                    return "Slot";
                }
                case 3: {
                    return "Child";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.collEvents.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Event ev = this.collEvents.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ev.getTimeString();
                }
                case 1: {
                    if (ev.getStepName().equals("AssignItemToSlot")) {
                        return "Item Assigned";
                    }
                    return "Collection replaced";
                }
                case 2: {
                    if (ev.getStepName().equals("AssignItemToSlot")) {
                        return ((String[])this.collEventData.get(rowIndex))[1];
                    }
                    return "";
                }
                case 3: {
                    String name;
                    if (ev.getStepName().equals("AddC2KObject")) {
                        return "Click to view";
                    }
                    try {
                        ItemProxy childItem = Gateway.getProxyManager().getProxy((Path)new ItemPath(((String[])this.collEventData.get(rowIndex))[2]));
                        name = childItem.getName();
                    }
                    catch (ObjectNotFoundException e) {
                        name = "Item deleted: " + ((String[])this.collEventData.get(rowIndex))[2];
                    }
                    catch (Exception e) {
                        name = "Problem resolving Item key: " + ((String[])this.collEventData.get(rowIndex))[2];
                    }
                    return name;
                }
            }
            return "";
        }

        public Object getEventData(int row) {
            return this.collEventData.get(row);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void add(Event thisEv) {
            String[] params;
            if (!thisEv.getStepName().equals("AssignItemToSlot") && !thisEv.getStepName().equals("AddC2KObject")) return;
            try {
                Outcome oc = (Outcome)this.item.getObject(ClusterStorage.OUTCOME + "/PredefinedStepOutcome/0/" + thisEv.getID());
                params = PredefinedStep.getDataList((String)oc.getData());
            }
            catch (ObjectNotFoundException ex) {
                return;
            }
            if (thisEv.getStepName().equals("AssignItemToSlot")) {
                if (!params[0].equals(this.coll.getName())) return;
                this.collEventData.add(params);
            } else {
                Object obj;
                try {
                    obj = Gateway.getMarshaller().unmarshall(params[0]);
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                    return;
                }
                if (!(obj instanceof Collection)) return;
                this.collEventData.add(obj);
            }
            this.collEvents.add(thisEv);
            this.fireTableRowsInserted(this.collEvents.size() - 1, this.collEvents.size() - 1);
        }

        public void remove(String id) {
        }

        public void control(String control, String msg) {
        }
    }
}

