/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.awt.Component;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.cristalise.gui.tabs.outcome.form.field.EditField;
import org.cristalise.gui.tabs.outcome.form.field.ListOfValues;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;

public class ComboField
extends EditField {
    JComboBox comboField = new JComboBox();
    ListOfValues vals;
    DefaultComboBoxModel comboModel;
    AnyNode listNode;

    public ComboField(SimpleType type, AnyNode listNode) {
        this.content = type;
        this.listNode = listNode;
        this.createLOV();
    }

    @Override
    public String getDefaultValue() {
        if (this.vals.getDefaultKey() != null) {
            return this.vals.get(this.vals.getDefaultKey()).toString();
        }
        return "";
    }

    public void setDefaultValue(String defaultVal) {
        this.vals.setDefaultValue(defaultVal);
        this.comboModel.setSelectedItem(this.vals.getDefaultKey());
    }

    @Override
    public String getText() {
        return this.vals.get(this.comboModel.getSelectedItem()).toString();
    }

    @Override
    public JTextComponent makeTextField() {
        return null;
    }

    @Override
    public void setText(String text) {
        if (this.vals.containsValue(text)) {
            this.comboModel.setSelectedItem(this.vals.findKey(text));
        } else {
            Logger.error((String)("Illegal value for ComboField " + this.getName() + ": " + text), (Object[])new Object[0]);
        }
    }

    @Override
    public Component getControl() {
        return this.comboField;
    }

    private void createLOV() {
        this.vals = new ListOfValues();
        if (this.listNode != null) {
            String lovType = this.listNode.getLocalName();
            String param = this.listNode.getFirstChild().getStringValue();
            if (lovType.equals("ScriptList")) {
                this.populateLOVFromScript(param);
            }
            if (lovType.equals("PathList")) {
                this.populateLOVFromLDAP(param);
            }
        }
        if (this.content.hasFacet("enumeration")) {
            Enumeration enums = this.content.getFacets("enumeration");
            while (enums.hasMoreElements()) {
                Annotation thisAnno;
                Enumeration docs;
                Facet thisEnum = (Facet)enums.nextElement();
                String desc = thisEnum.getValue();
                Enumeration annos = thisEnum.getAnnotations();
                if (annos.hasMoreElements() && (docs = (thisAnno = (Annotation)annos.nextElement()).getDocumentation()).hasMoreElements()) {
                    desc = ((Documentation)docs.nextElement()).getContent();
                }
                this.vals.put(desc, thisEnum.getValue(), false);
            }
        }
        this.comboModel = new DefaultComboBoxModel<String>(this.vals.getKeyArray());
        this.comboField.setModel(this.comboModel);
    }

    private void populateLOVFromLDAP(String param) {
    }

    private void populateLOVFromScript(String scriptName) {
        try {
            StringTokenizer tok = new StringTokenizer(scriptName, "_");
            if (tok.countTokens() != 2) {
                throw new Exception("Invalid LOVScript name");
            }
            Script lovscript = LocalObjectLoader.getScript((String)tok.nextToken(), (int)Integer.parseInt(tok.nextToken()));
            lovscript.setInputParamValue("LOV", (Object)this.vals);
            lovscript.execute();
        }
        catch (Exception ex) {
            MainFrame.exceptionDialog(ex);
        }
    }

    @Override
    public void setDecl(AttributeDecl model) throws StructuralException {
        super.setDecl(model);
        this.setDefaultValue(model.getDefaultValue());
    }

    @Override
    public void setDecl(ElementDecl model) throws StructuralException {
        super.setDecl(model);
        this.setDefaultValue(model.getDefaultValue());
    }

    @Override
    public void setEditable(boolean editable) {
        this.comboField.setEditable(editable);
    }
}

