/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.cristalise.gui.DomainKeyConsumer;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.cristalise.gui.tabs.outcome.form.field.ArrayEditField;
import org.cristalise.gui.tabs.outcome.form.field.BooleanEditField;
import org.cristalise.gui.tabs.outcome.form.field.ComboField;
import org.cristalise.gui.tabs.outcome.form.field.DecimalEditField;
import org.cristalise.gui.tabs.outcome.form.field.ImageEditField;
import org.cristalise.gui.tabs.outcome.form.field.IntegerEditField;
import org.cristalise.gui.tabs.outcome.form.field.LongStringEditField;
import org.cristalise.kernel.lookup.DomainPath;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AppInfo;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EditField
implements FocusListener,
DomainKeyConsumer {
    Node data;
    Structure model;
    protected SimpleType content;
    protected JTextComponent field = this.makeTextField();
    boolean isValid = true;
    boolean editable = true;
    String name;

    public EditField() {
        if (this.field != null) {
            this.field.addFocusListener(this);
        }
    }

    private static EditField getFieldForType(SimpleType type) {
        Class<?> contentClass;
        if (type instanceof ListType) {
            return new ArrayEditField(type.getBuiltInBaseType());
        }
        if (type.hasFacet("enumeration")) {
            return new ComboField(type, null);
        }
        Enumeration e = type.getAnnotations();
        while (e.hasMoreElements()) {
            Annotation note = (Annotation)e.nextElement();
            Enumeration f = note.getAppInfo();
            while (f.hasMoreElements()) {
                AppInfo thisAppInfo = (AppInfo)f.nextElement();
                Enumeration g = thisAppInfo.getObjects();
                while (g.hasMoreElements()) {
                    AnyNode appInfoNode = (AnyNode)g.nextElement();
                    if (!appInfoNode.getLocalName().equals("ScriptList") && !appInfoNode.getLocalName().equals("LDAPList")) continue;
                    return new ComboField(type, appInfoNode);
                }
            }
        }
        long length = -1L;
        if (type.getLength() != null) {
            length = type.getLength();
        } else if (type.getMaxLength() != null) {
            length = type.getMaxLength();
        } else if (type.getMinLength() != null) {
            length = type.getMinLength();
        }
        if (!type.isBuiltInType()) {
            type = type.getBuiltInBaseType();
        }
        if ((contentClass = OutcomeStructure.getJavaClass(type.getTypeCode())).equals(Boolean.class)) {
            return new BooleanEditField();
        }
        if (contentClass.equals(BigInteger.class)) {
            return new IntegerEditField();
        }
        if (contentClass.equals(BigDecimal.class)) {
            return new DecimalEditField();
        }
        if (contentClass.equals(ImageIcon.class)) {
            return new ImageEditField();
        }
        if (length > 60L) {
            return new LongStringEditField();
        }
        return new EditField();
    }

    public static EditField getEditField(AttributeDecl model) throws StructuralException {
        if (model.isReference()) {
            model = model.getReference();
        }
        EditField newField = EditField.getFieldForType(model.getSimpleType());
        newField.setDecl(model);
        return newField;
    }

    public static EditField getEditField(ElementDecl model, HashMap<String, Class<?>> specialControls) throws StructuralException {
        try {
            XMLType baseType = model.getType();
            while (!(baseType instanceof SimpleType)) {
                baseType = baseType.getBaseType();
            }
            EditField newField = specialControls.containsKey(model.getName()) ? (EditField)specialControls.get(model.getName()).newInstance() : EditField.getFieldForType((SimpleType)baseType);
            newField.setDecl(model);
            return newField;
        }
        catch (Exception ex) {
            throw new StructuralException("No type defined in model");
        }
    }

    public void setDecl(AttributeDecl model) throws StructuralException {
        this.model = model;
        this.content = model.getSimpleType();
        this.name = model.getName();
        if (model.isFixed()) {
            this.setEditable(false);
        }
    }

    public void setDecl(ElementDecl model) throws StructuralException {
        this.model = model;
        this.name = model.getName();
        XMLType type = model.getType();
        this.content = type.isSimpleType() ? (SimpleType)type : (SimpleType)type.getBaseType();
        if (this.content == null) {
            throw new StructuralException("No declared base type of element");
        }
        if (model.getFixedValue() != null) {
            this.setEditable(false);
        }
    }

    public void setData(Attr newData) throws StructuralException {
        if (!newData.getName().equals(this.name)) {
            throw new StructuralException("Tried to add a " + newData.getName() + " into a " + this.name + " attribute.");
        }
        this.data = newData;
        this.setText(newData.getValue());
    }

    public void setData(Text newData) {
        String contents = newData.getData();
        this.data = newData;
        this.setText(contents);
    }

    public void setData(String newData) throws OutcomeException {
        if (this.data == null) {
            throw new OutcomeException("No node exists");
        }
        this.setText(newData);
        this.updateNode();
    }

    public Structure getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public Node getData() {
        return this.data;
    }

    public String getDefaultValue() {
        return "";
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (MainFrame.itemFinder != null) {
            MainFrame.itemFinder.clearConsumer(this);
        }
        this.updateNode();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.editable && MainFrame.itemFinder != null) {
            MainFrame.itemFinder.setConsumer(this, "Insert");
        }
    }

    public void updateNode() {
        if (this.data == null) {
            return;
        }
        if (this.data instanceof Text) {
            ((Text)this.data).setData(this.getText());
        } else {
            ((Attr)this.data).setValue(this.getText());
        }
    }

    @Override
    public void push(DomainPath key) {
        this.setText(key.getName());
    }

    @Override
    public void push(String key) {
        this.setText(key);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.field != null) {
            this.field.setEditable(editable);
        }
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String text) {
        this.field.setText(text);
    }

    public JTextComponent makeTextField() {
        return new JTextField();
    }

    public Component getControl() {
        return this.field;
    }

    public void grabFocus() {
        this.getControl().requestFocus();
    }
}

