/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.awt.Toolkit;
import java.math.BigInteger;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.cristalise.gui.tabs.outcome.form.field.EditField;

public class IntegerEditField
extends EditField {
    public IntegerEditField() {
        this.field.setToolTipText("This field must contains a whole number e.g. 3");
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    @Override
    public void setText(String text) {
        this.field.setText(text);
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }

    @Override
    public JTextComponent makeTextField() {
        return new IntegerTextField();
    }

    private class IntegerDocument
    extends PlainDocument {
        private IntegerDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.equals("")) {
                return;
            }
            String proposedResult = null;
            if (this.getLength() == 0) {
                proposedResult = str;
            } else {
                StringBuffer currentBuffer = new StringBuffer(this.getText(0, this.getLength()));
                currentBuffer.insert(offs, str);
                proposedResult = currentBuffer.toString();
            }
            try {
                this.parse(proposedResult);
                super.insertString(offs, str, a);
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(len + offs, currentText.length());
            String proposedResult = beforeOffset + afterOffset;
            if (proposedResult.length() == 0) {
                super.remove(offs, len);
                return;
            }
            try {
                this.parse(proposedResult);
                super.remove(offs, len);
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public BigInteger parse(String proposedResult) throws NumberFormatException {
            BigInteger value = new BigInteger("0");
            if (proposedResult.length() != 0) {
                value = new BigInteger(proposedResult);
            }
            return value;
        }
    }

    private class IntegerTextField
    extends JTextField {
        public IntegerTextField() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected Document createDefaultModel() {
            return new IntegerDocument();
        }
    }
}

