/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.MainFrame;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;

public class RoleAdmin
extends Box
implements ActionListener {
    AgentProxy agent;
    JTable table;
    RoleTableModel model = new RoleTableModel();
    JButton addButton;
    JButton removeButton;
    JButton saveButton;

    public RoleAdmin() {
        super(1);
        this.table = new JTable(this.model);
        this.add(new JScrollPane(this.table));
        this.add(Box.createVerticalGlue());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        this.addButton = new JButton("Add");
        buttonBox.add(this.addButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.removeButton = new JButton("Remove");
        buttonBox.add(this.removeButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.saveButton = new JButton("Save");
        buttonBox.add(this.saveButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.add(buttonBox);
        this.addButton.setActionCommand("add");
        this.addButton.addActionListener(this);
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(this);
        this.saveButton.setActionCommand("save");
        this.saveButton.addActionListener(this);
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.saveButton.setEnabled(false);
    }

    public void setEntity(AgentProxy agent) {
        this.agent = agent;
        this.model.loadPaths();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("add")) {
            String newPath = JOptionPane.showInputDialog(this, "Enter new path", "Add Role Path", -1);
            this.model.addRole(newPath);
            this.saveButton.setEnabled(true);
        } else if (e.getActionCommand().equals("remove")) {
            if (this.table.getSelectedRow() > -1) {
                this.model.removeRole(this.table.getSelectedRow());
                this.saveButton.setEnabled(true);
            }
        } else if (e.getActionCommand().equals("save")) {
            try {
                MainFrame.userAgent.execute((ItemProxy)this.agent, "SetAgentRoles", this.model.getRolePaths());
                this.saveButton.setEnabled(false);
            }
            catch (Exception ex) {
                MainFrame.exceptionDialog(ex);
            }
        }
    }

    private class RoleTableModel
    extends AbstractTableModel {
        ArrayList<RolePath> rolePaths = new ArrayList();

        public void removeRole(int selectedRow) {
            if (this.rolePaths.size() > 0) {
                this.rolePaths.remove(selectedRow);
            }
            if (this.rolePaths.size() < 1) {
                RoleAdmin.this.removeButton.setEnabled(false);
            }
            this.fireTableDataChanged();
        }

        public String[] getRolePaths() {
            String[] roleNames = new String[this.rolePaths.size()];
            int i = 0;
            for (RolePath role : this.rolePaths) {
                roleNames[i++] = role.toString();
            }
            return roleNames;
        }

        public void addRole(String newPath) {
            RolePath newRole;
            try {
                newRole = Gateway.getLookup().getRolePath(newPath);
            }
            catch (ObjectNotFoundException e) {
                MainFrame.exceptionDialog((Exception)((Object)e));
                return;
            }
            if (this.rolePaths.contains(newRole)) {
                JOptionPane.showMessageDialog(null, "Role already assigned to agent", "Error assigning Role", 0);
                return;
            }
            this.rolePaths.add(newRole);
            RoleAdmin.this.removeButton.setEnabled(true);
            this.fireTableDataChanged();
        }

        public void loadPaths() {
            this.rolePaths.clear();
            for (RolePath currentRole : Gateway.getLookup().getRoles(RoleAdmin.this.agent.getPath())) {
                this.rolePaths.add(currentRole);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "Role";
        }

        @Override
        public int getRowCount() {
            return this.rolePaths.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rolePaths.get(rowIndex).toString();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

