/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.cristalise.gui.DomainKeyConsumer;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.form.CardinalException;
import org.cristalise.gui.tabs.outcome.form.DimensionInstance;
import org.cristalise.gui.tabs.outcome.form.DimensionTableModel;
import org.cristalise.gui.tabs.outcome.form.MultiLinePasteAdapter;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.cristalise.gui.tabs.outcome.form.StructuralException;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Particle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Dimension
extends OutcomeStructure
implements ActionListener {
    DimensionTableModel tableModel;
    Element parent;
    GridBagConstraints position;
    GridBagLayout gridbag;
    JTabbedPane tabs;
    JLabel msg;
    DomKeyPushTable table;
    Box tableBox;
    ArrayList<DimensionInstance> instances = new ArrayList();
    ArrayList<Element> elements = new ArrayList();
    JButton addButton;
    JButton delButton;
    short mode;
    protected static final short TABLE = 1;
    protected static final short TABS = 2;

    public Dimension(ElementDecl model, boolean readOnly, HashMap<String, Class<?>> specialControls) {
        super(model, readOnly, specialControls);
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.position = new GridBagConstraints();
        this.position.anchor = 18;
        this.position.fill = 2;
        this.position.weightx = 1.0;
        this.position.weighty = 0.0;
        this.position.gridx = 0;
        this.position.gridy = 0;
        this.position.ipadx = 0;
        this.position.ipady = 0;
        this.position.insets = new Insets(0, 0, 0, 0);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), model.getName()));
        this.msg = new JLabel("No elements");
        this.msg.setFont(new Font("SansSerif", 2, this.msg.getFont().getSize()));
        this.gridbag.setConstraints(this.msg, this.position);
        this.add(this.msg);
        ++this.position.gridy;
        try {
            this.tableModel = new DimensionTableModel(model, readOnly);
            Logger.msg((int)8, (String)("DIM " + model.getName() + " - Will be a table"), (Object[])new Object[0]);
            if (this.help != null) {
                this.add((Component)Dimension.makeLabel(null, this.help), this.position);
                ++this.position.gridy;
            }
            this.mode = 1;
            this.tableBox = Box.createVerticalBox();
            this.table = new DomKeyPushTable(this.tableModel, this);
            new MultiLinePasteAdapter(this.table, this);
            if (readOnly) {
                this.table.setSelectionMode(0);
            }
            this.table.setAutoResizeMode(4);
            this.table.setColumnSelectionAllowed(readOnly);
            JTableHeader tableHeader = this.table.getTableHeader();
            tableHeader.setReorderingAllowed(false);
            this.tableBox.add(tableHeader);
            this.tableBox.add(this.table);
            this.gridbag.setConstraints(this.tableBox, this.position);
            this.add(this.tableBox);
            this.tableBox.setVisible(false);
        }
        catch (StructuralException e) {
            Logger.msg((int)8, (String)("DIM " + model.getName() + " - Will be tabs: " + e.getMessage()), (Object[])new Object[0]);
            this.mode = (short)2;
            this.tabs = new JTabbedPane();
            this.gridbag.setConstraints(this.tabs, this.position);
            this.add(this.tabs);
            this.tabs.setVisible(false);
        }
        if (!readOnly) {
            JPanel rowAdjust = new JPanel(new FlowLayout());
            this.addButton = new JButton("+");
            this.addButton.setActionCommand("add");
            this.addButton.addActionListener(this);
            rowAdjust.add(this.addButton);
            this.delButton = new JButton("-");
            this.delButton.setActionCommand("del");
            this.delButton.addActionListener(this);
            this.delButton.setEnabled(false);
            rowAdjust.add(this.delButton);
            ++this.position.gridy;
            this.position.weighty = 0.0;
            this.position.weightx = 0.0;
            this.gridbag.setConstraints(rowAdjust, this.position);
            this.add(rowAdjust);
        }
    }

    public void setParentElement(Element parent) {
        this.parent = parent;
    }

    @Override
    public void addInstance(Element myElement, Document parentDoc) throws OutcomeException {
        if (Logger.doLog((int)6)) {
            Logger.msg((int)6, (String)("DIM - adding instance " + (this.elements.size() + 1) + " for " + myElement.getTagName()), (Object[])new Object[0]);
        }
        if (this.parent == null) {
            this.setParentElement((Element)myElement.getParentNode());
        }
        if (this.mode == 1) {
            this.tableModel.addInstance(myElement, -1);
            this.elements.add(myElement);
        } else {
            this.elements.add(myElement);
            DimensionInstance target = this.instances.size() < this.elements.size() ? this.newInstance() : this.instances.get(this.elements.size() - 1);
            target.addInstance(myElement, parentDoc);
            this.tabs.setTitleAt(this.tabs.indexOfComponent(target), target.getName());
        }
        this.checkButtons();
    }

    public int getChildCount() {
        return this.elements.size();
    }

    public DimensionInstance newInstance() {
        DimensionInstance newInstance = null;
        try {
            newInstance = new DimensionInstance(this.model, this.readOnly, this.deferChild, this.specialEditFields);
            this.instances.add(newInstance);
            newInstance.setTabNumber(this.instances.size());
            newInstance.setParent(this);
            this.deferChild = true;
            this.tabs.addTab(newInstance.getName(), newInstance);
            this.tabs.addChangeListener(newInstance);
        }
        catch (OutcomeException e) {
            Logger.error((Throwable)e);
        }
        return newInstance;
    }

    @Override
    public String validateStructure() {
        if (this.mode == 1) {
            return this.table.validateStructure();
        }
        StringBuffer errors = new StringBuffer();
        for (OutcomeStructure outcomeStructure : this.instances) {
            errors.append(outcomeStructure.validateStructure());
        }
        return errors.toString();
    }

    public void checkButtons() {
        boolean dataVisible;
        boolean bl = dataVisible = this.elements.size() > 0;
        if (this.mode == 2) {
            this.tabs.setVisible(dataVisible);
        } else {
            this.tableBox.setVisible(dataVisible);
        }
        this.msg.setVisible(!dataVisible);
        if (this.readOnly) {
            return;
        }
        if (this.elements.size() <= this.model.getMinOccurs() || this.elements.size() == 0) {
            this.delButton.setEnabled(false);
            this.delButton.setToolTipText("Minimum row count of " + this.model.getMinOccurs() + " reached.");
        } else {
            this.delButton.setEnabled(true);
            this.delButton.setToolTipText(null);
        }
        if (this.elements.size() < this.model.getMaxOccurs() || this.model.getMaxOccurs() == Particle.UNBOUNDED) {
            this.addButton.setEnabled(true);
            this.addButton.setToolTipText(null);
        } else {
            this.addButton.setEnabled(false);
            this.addButton.setToolTipText("Maximum row count of " + this.model.getMaxOccurs() + " reached.");
        }
    }

    @Override
    public Element initNew(Document parent) {
        if (this.mode == 1) {
            Element newElement = this.tableModel.initNew(parent, -1);
            this.elements.add(newElement);
            this.checkButtons();
            return newElement;
        }
        DimensionInstance newTab = null;
        newTab = this.instances.size() < this.elements.size() + 1 ? this.newInstance() : this.instances.get(this.elements.size() - 1);
        Element newElement = newTab.initNew(parent);
        this.elements.add(newElement);
        this.checkButtons();
        return newElement;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index;
        if (this.mode == 2) {
            index = this.tabs.getSelectedIndex();
        } else {
            index = this.table.getSelectedRow();
            if (index == -1) {
                index = this.tableModel.getRowCount();
            }
        }
        try {
            if (this.table == null || this.table.getCellEditor() == null || this.table.getCellEditor().stopCellEditing()) {
                if (e.getActionCommand().equals("add")) {
                    this.addRow(index);
                } else if (e.getActionCommand().equals("del")) {
                    this.removeRow(index);
                }
            }
        }
        catch (CardinalException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Table error", 0);
        }
    }

    public void addRow(int index) throws CardinalException {
        if (this.elements.size() == this.model.getMaxOccurs()) {
            throw new CardinalException("Maximum size of table reached");
        }
        if (this.mode == 1) {
            Element newRow = this.tableModel.initNew(this.parent.getOwnerDocument(), index);
            this.elements.add(index, newRow);
            try {
                Element following = this.elements.get(index + 1);
                this.parent.insertBefore(newRow, following);
            }
            catch (IndexOutOfBoundsException ex) {
                this.parent.appendChild(newRow);
            }
            this.table.clearSelection();
            this.table.setRowSelectionInterval(index, index);
        } else {
            Element newTab = this.initNew(this.parent.getOwnerDocument());
            this.parent.appendChild(newTab);
        }
        this.checkButtons();
    }

    public void removeRow(int index) throws CardinalException {
        if (this.elements.size() <= this.model.getMinOccurs()) {
            throw new CardinalException("Minimum size of table reached");
        }
        if (this.mode == 1) {
            this.parent.removeChild(this.tableModel.removeRow(index));
            int selectRow = index;
            if (index >= this.tableModel.getRowCount()) {
                --selectRow;
            }
            if (this.tableModel.getRowCount() > 0) {
                this.table.clearSelection();
                this.table.setRowSelectionInterval(selectRow, selectRow);
            }
        } else {
            Element elementToGo = this.elements.get(index);
            this.parent.removeChild(elementToGo);
            this.instances.remove(index);
            this.tabs.remove(index);
            for (int i = index; i < this.instances.size(); ++i) {
                DimensionInstance thisInstance = this.instances.get(i);
                thisInstance.setTabNumber(i + 1);
                this.tabs.setTitleAt(i, thisInstance.getName());
            }
        }
        this.elements.remove(index);
        this.checkButtons();
    }

    @Override
    public void grabFocus() {
        if (this.mode == 1) {
            if (this.table.getSelectedRow() == -1 && this.table.getRowCount() > 0) {
                this.table.changeSelection(0, 0, false, false);
                this.table.editCellAt(0, 0);
            }
            this.table.requestFocus();
        } else if (this.instances.size() > 0) {
            this.instances.get(0).grabFocus();
        }
    }

    private class DomKeyPushTable
    extends JTable
    implements DomainKeyConsumer,
    FocusListener {
        Dimension dim;

        public DomKeyPushTable(DimensionTableModel model, Dimension parent) {
            super(model);
            this.addFocusListener(this);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.dim = parent;
        }

        @Override
        public void push(DomainPath key) {
            this.push(key.getName());
        }

        @Override
        public void push(String name) {
            int col = this.getSelectedColumn();
            int row = this.getSelectedRow();
            if (this.cellEditor != null) {
                this.cellEditor.stopCellEditing();
            }
            Logger.msg((int)8, (String)("Pushing " + name + " to table at " + row + "," + col), (Object[])new Object[0]);
            if (col > -1 && row > -1) {
                if (this.dataModel.getValueAt(row, col).toString().length() == 0) {
                    this.dataModel.setValueAt(name, row, col);
                } else if (row + 1 == this.getRowCount()) {
                    try {
                        this.dim.addRow(row + 1);
                        this.dataModel.setValueAt(name, row + 1, col);
                    }
                    catch (CardinalException ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Table error", 0);
                    }
                }
                if (row + 1 < this.getRowCount()) {
                    Logger.msg((int)8, (String)("Shifting selection to row " + (row + 1)), (Object[])new Object[0]);
                    this.changeSelection(row + 1, col, false, false);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!Dimension.this.readOnly) {
                MainFrame.itemFinder.setConsumer(this, "Insert");
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!Dimension.this.readOnly) {
                MainFrame.itemFinder.clearConsumer(this);
            }
        }

        public String validateStructure() {
            if (this.cellEditor != null) {
                this.cellEditor.stopCellEditing();
            }
            return null;
        }
    }
}

