/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import org.castor.core.util.Base64Decoder;
import org.castor.core.util.Base64Encoder;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.outcome.form.field.EditField;

public class ImageEditField
extends EditField {
    JLabel imageLabel = new JLabel();
    Box imagePanel = Box.createVerticalBox();
    JButton browseButton = new JButton("Browse");
    String encodedImage;
    static JFileChooser chooser = new JFileChooser();

    public ImageEditField() {
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        byte[] bArray = (byte[])Array.newInstance(Byte.TYPE, (int)file.length());
                        fis.read(bArray, 0, (int)file.length());
                        fis.close();
                        ImageIcon newImage = new ImageIcon(Toolkit.getDefaultToolkit().createImage(bArray));
                        ImageEditField.this.imageLabel.setIcon(newImage);
                        ImageEditField.this.encodedImage = String.valueOf(Base64Encoder.encode((byte[])bArray));
                    }
                    catch (Exception ex) {
                        MainFrame.exceptionDialog(ex);
                    }
                }
            }
        });
        this.imagePanel.add(this.imageLabel);
        this.imagePanel.add(Box.createVerticalStrut(5));
        this.imagePanel.add(this.browseButton);
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    public Component getControl() {
        return this.imagePanel;
    }

    @Override
    public String getText() {
        return this.encodedImage == null ? "" : this.encodedImage;
    }

    @Override
    public void setText(String text) {
        this.encodedImage = text;
        if (text != null && text.length() > 0) {
            byte[] decodedImage = Base64Decoder.decode((String)this.encodedImage);
            this.imageLabel.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(decodedImage)));
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.browseButton.setVisible(false);
    }

    static {
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Image Files";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && (f.getName().endsWith(".gif") || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg") || f.getName().endsWith(".png"));
            }
        });
    }
}

