/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.cristalise.gui.graph.controller.AutoScrollController;
import org.cristalise.gui.graph.controller.EdgeConstructionController;
import org.cristalise.gui.graph.controller.MultiSelectionDragController;
import org.cristalise.gui.graph.controller.VertexConstructionController;
import org.cristalise.gui.graph.view.EditorToolBar;
import org.cristalise.gui.graph.view.GraphPanel;
import org.cristalise.kernel.graph.model.EdgeFactory;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.graph.model.VertexFactory;
import org.cristalise.kernel.graph.model.VertexOutlineCreator;

public class EditorPanel
extends JPanel {
    public final GraphModelManager mGraphModelManager = new GraphModelManager();
    public GraphPanel mGraphPanel = null;
    protected JScrollPane mGraphScrollPane = null;
    protected MultiSelectionDragController mMultiSelectionDragController;
    protected VertexConstructionController mVertexConstructionController = new VertexConstructionController();
    protected EdgeConstructionController mEdgeConstructionController = new EdgeConstructionController();
    protected AutoScrollController mAutoScrollController = new AutoScrollController();
    protected EditorToolBar mEditorToolBar = null;

    protected EditorPanel() {
    }

    public EditorPanel(EdgeFactory eFactory, VertexFactory vFactory, VertexOutlineCreator vOutlineCreator, boolean edgeCreationMode, JButton[] otherButtons, GraphPanel graphPanel) {
        this.setDoubleBuffered(true);
        this.mGraphPanel = graphPanel;
        this.mGraphPanel.setGraphModelManager(this.mGraphModelManager);
        this.mGraphScrollPane = new JScrollPane(this.mGraphPanel);
        this.mGraphModelManager.setExternalEdgeFactory(eFactory);
        this.mGraphModelManager.setExternalVertexFactory(vFactory);
        this.mGraphModelManager.setVertexOutlineCreator(vOutlineCreator);
        this.mEditorToolBar = new EditorToolBar(edgeCreationMode, otherButtons, graphPanel);
        this.mEditorToolBar.setGraphModelManager(this.mGraphModelManager);
        this.mEditorToolBar.setGraphPanel(this.mGraphPanel);
        this.createLayout();
        this.mGraphModelManager.addObserver((Observer)this.mGraphPanel);
        this.mMultiSelectionDragController = new MultiSelectionDragController(this.mGraphModelManager, this.mGraphPanel);
        this.mGraphPanel.addMouseListener(this.mMultiSelectionDragController);
        this.mGraphPanel.addMouseMotionListener(this.mMultiSelectionDragController);
        this.mGraphPanel.addKeyListener(this.mMultiSelectionDragController);
        this.mEditorToolBar.addEditorModeListener(this.mMultiSelectionDragController);
        this.mEdgeConstructionController.setGraphModelManager(this.mGraphModelManager);
        this.mEdgeConstructionController.setGraphPanel(this.mGraphPanel);
        this.mGraphPanel.addMouseListener(this.mEdgeConstructionController);
        this.mGraphPanel.addMouseMotionListener(this.mEdgeConstructionController);
        this.mEdgeConstructionController.setEditorToolBar(this.mEditorToolBar);
        this.mVertexConstructionController.setGraphModelManager(this.mGraphModelManager);
        this.mGraphPanel.addMouseListener(this.mVertexConstructionController);
        this.mVertexConstructionController.setEditorToolBar(this.mEditorToolBar);
        this.mAutoScrollController.setGraphPanel(this.mGraphPanel);
    }

    protected void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.mEditorToolBar, "North");
        this.mGraphPanel.setPreferredSize(new Dimension(this.mGraphModelManager.getModel().getWidth(), this.mGraphModelManager.getModel().getHeight()));
        this.add((Component)this.mGraphScrollPane, "Center");
    }

    public void enterSelectMode() {
        this.mEditorToolBar.enterSelectMode();
    }

    public void updateEdgeTypes(TypeNameAndConstructionInfo[] typeNameAndConstructionInfo) {
        this.mEditorToolBar.updateEdgeTypes(typeNameAndConstructionInfo);
    }

    public void updateVertexTypes(TypeNameAndConstructionInfo[] typeNameAndConstructionInfo) {
        this.mEditorToolBar.updateVertexTypes(typeNameAndConstructionInfo);
    }

    public void setEditable(boolean editable) {
        this.mGraphModelManager.setEditable(editable);
        this.mEditorToolBar.setGraphEditable(editable);
    }
}

