/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.collection;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.graph.view.VertexRenderer;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.utils.Logger;

public class AggregationMemberRenderer
implements VertexRenderer {
    private Aggregation mAggregation = null;

    public void setAggregation(Aggregation agg) {
        this.mAggregation = agg;
    }

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        GraphPoint centre = vertex.getCentrePoint();
        GraphPoint[] outline = vertex.getOutlinePoints();
        FontMetrics metrics = g2d.getFontMetrics();
        AggregationMember memberPair = this.mAggregation.getMemberPair(vertex.getID());
        try {
            String name = memberPair.getItemName();
            g2d.drawString(name, centre.x - metrics.stringWidth(name) / 2, vertex.getID() % 2 == 0 ? this.topYOfOutline(outline) : this.bottomYOfOutline(outline) + metrics.getHeight());
            g2d.drawImage(this.getImage(memberPair), centre.x - 8, centre.y - 8, null);
            if (outline.length > 1) {
                for (int i = 0; i < outline.length - 1; ++i) {
                    g2d.drawLine(outline[i].x, outline[i].y, outline[i + 1].x, outline[i + 1].y);
                }
                g2d.drawLine(outline[outline.length - 1].x, outline[outline.length - 1].y, outline[0].x, outline[0].y);
            }
        }
        catch (Exception ex) {
            Logger.error((String)("AggregationMemberRenderer::draw() " + ex), (Object[])new Object[0]);
        }
    }

    int topYOfOutline(GraphPoint[] outline) {
        int topY = outline[0].y;
        int i = 0;
        for (i = 1; i < outline.length; ++i) {
            if (outline[i].y >= topY) continue;
            topY = outline[i].y;
        }
        return topY;
    }

    int bottomYOfOutline(GraphPoint[] outline) {
        int bottomY = outline[0].y;
        int i = 0;
        for (i = 1; i < outline.length; ++i) {
            if (outline[i].y <= bottomY) continue;
            bottomY = outline[i].y;
        }
        return bottomY;
    }

    public Image getImage(AggregationMember am) {
        return ImageLoader.findImage("typeicons/" + am.getProperties().get((Object)"Type") + "_16.png").getImage();
    }
}

