/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.view;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import org.cristalise.gui.graph.view.VertexRenderer;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;

public class DefaultVertexRenderer
implements VertexRenderer {
    private Paint mLinePaint = null;
    private Paint mTextPaint = null;
    private Paint mFillPaint = null;

    public DefaultVertexRenderer(Paint linePaint, Paint textPaint, Paint fillPaint) {
        this.mLinePaint = linePaint;
        this.mTextPaint = textPaint;
        this.mFillPaint = fillPaint;
    }

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        GraphPoint[] outlinePoints = vertex.getOutlinePoints();
        GraphPoint centrePoint = vertex.getCentrePoint();
        Polygon outline = new Polygon();
        String vertexName = vertex.getName();
        FontMetrics metrics = g2d.getFontMetrics();
        int textWidth = metrics.stringWidth(vertexName);
        int textHeight = metrics.getHeight();
        int textX = centrePoint.x - textWidth / 2;
        int textY = centrePoint.y + textHeight / 3;
        int i = 0;
        for (i = 0; i < outlinePoints.length; ++i) {
            outline.addPoint(outlinePoints[i].x, outlinePoints[i].y);
        }
        g2d.setPaint(this.mFillPaint);
        g2d.fill(outline);
        g2d.setPaint(this.mLinePaint);
        g2d.draw(outline);
        g2d.setPaint(this.mTextPaint);
        g2d.drawString(vertexName, textX, textY);
    }
}

