/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome.form.field;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import org.cristalise.gui.tabs.outcome.form.OutcomeStructure;
import org.exolab.castor.xml.schema.SimpleType;

public class ArrayTableModel
extends AbstractTableModel {
    ArrayList<Object> contents = new ArrayList();
    Class<?> type;
    int numCols = 1;
    boolean readOnly = false;

    public ArrayTableModel(SimpleType type) {
        this.type = OutcomeStructure.getJavaClass(type.getTypeCode());
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setData(String data) {
        this.contents.clear();
        StringTokenizer tok = new StringTokenizer(data);
        while (tok.hasMoreTokens()) {
            this.contents.add(OutcomeStructure.getTypedValue(tok.nextToken(), this.type));
        }
        this.fireTableStructureChanged();
    }

    public String getData() {
        if (this.contents.size() == 0) {
            return "";
        }
        Iterator<Object> iter = this.contents.iterator();
        StringBuffer result = new StringBuffer(iter.next().toString());
        while (iter.hasNext()) {
            result.append(" ").append(iter.next().toString());
        }
        return result.toString();
    }

    public void addField() {
        this.contents.add(OutcomeStructure.getTypedValue("", this.type));
        this.fireTableStructureChanged();
    }

    public void removeField() {
        this.contents.remove(this.contents.size() - 1);
        this.fireTableStructureChanged();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.type;
    }

    @Override
    public int getColumnCount() {
        return this.numCols;
    }

    public int getArrayLength() {
        return this.contents.size();
    }

    public void setColumnCount(int newCols) {
        this.numCols = newCols;
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int column) {
        return "Value";
    }

    @Override
    public int getRowCount() {
        return this.contents.size() / this.numCols + 1;
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        int index = arg1 + arg0 * this.numCols;
        if (index >= this.contents.size()) {
            return null;
        }
        return this.contents.get(arg1 + arg0 * this.numCols);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex + rowIndex * this.numCols > this.contents.size() - 1) {
            return false;
        }
        return !this.readOnly;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.contents.set(columnIndex + rowIndex * this.numCols, aValue);
    }
}

