/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs.outcome;

import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cristalise.gui.tabs.outcome.InvalidOutcomeException;
import org.cristalise.gui.tabs.outcome.InvalidSchemaException;
import org.cristalise.gui.tabs.outcome.OutcomeException;
import org.cristalise.gui.tabs.outcome.OutcomeHandler;
import org.cristalise.gui.tabs.outcome.OutcomeNotInitialisedException;
import org.cristalise.kernel.utils.FileStringUtility;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class BasicOutcomeEditor
extends JPanel
implements OutcomeHandler {
    RSyntaxTextArea textarea;
    RSyntaxDocument doc;
    boolean unsaved;

    public BasicOutcomeEditor() {
        this.setLayout(new GridLayout(1, 1));
        this.doc = new RSyntaxDocument("text/xml");
        this.textarea = new RSyntaxTextArea(this.doc);
        this.textarea.setAutoIndentEnabled(true);
        this.textarea.setCodeFoldingEnabled(true);
        RTextScrollPane scroll = new RTextScrollPane((RTextArea)this.textarea);
        scroll.setLineNumbersEnabled(true);
        this.add((Component)scroll);
        this.doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                BasicOutcomeEditor.this.unsaved = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BasicOutcomeEditor.this.unsaved = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BasicOutcomeEditor.this.unsaved = true;
            }
        });
    }

    @Override
    public void setOutcome(String outcome) throws InvalidOutcomeException {
        try {
            this.doc.insertString(0, outcome, null);
            this.unsaved = false;
        }
        catch (Exception ex) {
            throw new InvalidOutcomeException(ex.getMessage());
        }
    }

    @Override
    public void setDescription(String description) throws InvalidSchemaException {
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.textarea.setEditable(!readOnly);
    }

    @Override
    public JPanel getPanel() throws OutcomeNotInitialisedException {
        return this;
    }

    @Override
    public String getOutcome() throws OutcomeException {
        if (this.doc.getLength() == 0) {
            return null;
        }
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (Exception ex) {
            throw new OutcomeException(ex.getMessage());
        }
    }

    @Override
    public void run() {
        this.revalidate();
        this.doLayout();
    }

    @Override
    public boolean isUnsaved() {
        return this.unsaved;
    }

    @Override
    public void saved() {
        this.unsaved = false;
    }

    @Override
    public void export(File targetFile) throws Exception {
        FileStringUtility.string2File((File)targetFile, (String)this.getOutcome());
    }
}

