/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tree;

import java.awt.datatransfer.Transferable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.TreeBrowser;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeCollection;
import org.cristalise.gui.tree.NodeItem;
import org.cristalise.kernel.utils.Logger;

public class NodeTransferHandler
extends TransferHandler {
    TreeBrowser tree;

    public NodeTransferHandler(TreeBrowser treeBrowser) {
        this.tree = treeBrowser;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        Node selNode = this.tree.getSelectedNode();
        if (selNode instanceof Transferable) {
            return (Transferable)((Object)selNode);
        }
        return null;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        Node dropNode = this.tree.getNodeAt(support.getDropLocation().getDropPoint());
        if (dropNode instanceof NodeCollection) {
            NodeCollection collNode = (NodeCollection)dropNode;
            try {
                NodeItem source = (NodeItem)support.getTransferable().getTransferData(NodeItem.dataFlavor);
                return collNode.addMember(source.getItemPath());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                return false;
            }
        }
        return super.importData(support);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean isNode = support.isDataFlavorSupported(NodeItem.dataFlavor);
        if (!isNode) {
            return false;
        }
        Node dropNode = this.tree.getNodeAt(support.getDropLocation().getDropPoint());
        return MainFrame.isAdmin && dropNode instanceof NodeCollection && ((NodeCollection)dropNode).isDependency();
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        if (t instanceof NodeItem) {
            return ((NodeItem)t).getIcon();
        }
        return ImageLoader.nullImg;
    }
}

