/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tabs.JFixedHeightComboBox;
import org.cristalise.gui.tabs.execution.ActivityItem;
import org.cristalise.gui.tabs.execution.ActivityViewer;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.utils.Logger;

public class ExecutionPane
extends ItemTabPane
implements ProxyObserver<Workflow> {
    ArrayList<Job> jobList = null;
    Object jobLock = new Object();
    ActivityItem emptyAct = new ActivityItem();
    JLabel noActs = new JLabel("There are currently no activities that you can execute in this item.");
    JPanel view = new JPanel(new GridLayout(1, 1));
    ActivityViewer currentActView;
    JComboBox<ActivityItem> activitySelector = new JFixedHeightComboBox<ActivityItem>();
    String selAct = null;
    ArrayList<ActivityItem> activities;
    String autoRun = null;
    boolean init = false;
    boolean formIsActive = false;

    public ExecutionPane() {
        super("Execution", "Activity Execution");
        super.initPanel();
        Box activityBox = Box.createHorizontalBox();
        JLabel actTitle = new JLabel("Activity: ");
        actTitle.setFont(ItemTabPane.titleFont);
        activityBox.add(actTitle);
        activityBox.add(Box.createHorizontalStrut(5));
        this.activitySelector.setEditable(false);
        this.activitySelector.setFont(ItemTabPane.titleFont);
        activityBox.add(this.activitySelector);
        activityBox.setMaximumSize(this.activitySelector.getMaximumSize());
        this.activitySelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent selection) {
                if (selection.getStateChange() == 1) {
                    ExecutionPane.this.selectActivity(selection.getItem());
                }
            }
        });
        this.add(activityBox);
        this.add(Box.createVerticalStrut(5));
        this.add(this.view);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Execution Pane Builder");
        this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, ClusterType.LIFECYCLE.getName(), false));
        this.loadJobList();
        this.init = true;
        if (this.autoRun != null) {
            this.runCommand(this.autoRun);
            this.autoRun = null;
        } else if (this.activities.size() == 1) {
            this.currentActView.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobList() {
        Object object = this.jobLock;
        synchronized (object) {
            this.activitySelector.removeAllItems();
            this.view.removeAll();
            this.activities = new ArrayList();
            try {
                this.jobList = this.sourceItem.getItem().getJobList(MainFrame.userAgent);
                this.activitySelector.addItem(this.emptyAct);
                for (Job thisJob : this.jobList) {
                    ActivityItem newAct = new ActivityItem(thisJob);
                    if (this.activities.contains(newAct)) {
                        int actIndex = this.activities.indexOf(newAct);
                        this.activities.get(actIndex).addJob(thisJob);
                        continue;
                    }
                    Logger.msg((int)2, (String)("ExecutionPane - Adding activity " + thisJob.getStepPath()), (Object[])new Object[0]);
                    this.addActivity(newAct);
                }
            }
            catch (Exception e) {
                Logger.error((String)"Error fetching joblist", (Object[])new Object[0]);
                Logger.error((Throwable)e);
            }
            switch (this.activities.size()) {
                case 0: {
                    this.view.add(this.noActs);
                    break;
                }
                case 1: {
                    this.currentActView = new ActivityViewer(this.activities.get(0), this.sourceItem.getItem(), this);
                    this.view.add(this.currentActView);
                    break;
                }
            }
        }
        this.revalidate();
        this.updateUI();
    }

    @Override
    public void reload() {
        this.loadJobList();
        if (this.activities.size() == 1) {
            this.currentActView.init();
        }
    }

    private void addActivity(ActivityItem newAct) {
        if (this.activities.contains(newAct)) {
            Logger.msg((int)6, (String)("ExecutionPane.addActivity(): Already in " + newAct.getStepPath()), (Object[])new Object[0]);
            int actIndex = this.activities.indexOf(newAct);
            this.activitySelector.removeItemAt(actIndex);
            this.activitySelector.insertItemAt(newAct, actIndex);
            this.activities.set(actIndex, newAct);
        } else {
            Logger.msg((int)6, (String)("ExecutionPane.addActivity(): New " + newAct.getStepPath()), (Object[])new Object[0]);
            this.activities.add(newAct);
            this.activitySelector.addItem(newAct);
        }
    }

    private void selectActivity(Object selObj) {
        if (selObj.equals(this.emptyAct)) {
            return;
        }
        this.view.removeAll();
        this.currentActView = new ActivityViewer((ActivityItem)selObj, this.sourceItem.getItem(), this);
        this.view.add(this.currentActView);
        this.revalidate();
        this.updateUI();
        this.currentActView.init();
    }

    @Override
    public void runCommand(String command) {
        if (this.init) {
            for (ActivityItem act : this.activities) {
                if (!act.name.equals(command)) continue;
                this.activitySelector.setSelectedItem(act);
            }
        } else {
            this.autoRun = command;
        }
    }

    public void add(Workflow contents) {
        if (!this.formIsActive) {
            this.reload();
        } else {
            boolean allValid;
            boolean stillValid;
            try {
                this.jobList = this.sourceItem.getItem().getJobList(MainFrame.userAgent);
            }
            catch (Exception ex) {
                return;
            }
            ArrayList<Job> currentActJobs = this.currentActView.getActivity().getJobs();
            Iterator<Job> iter = currentActJobs.iterator();
            block2: for (allValid = true; iter.hasNext() && allValid; allValid &= stillValid) {
                Job thisJob = iter.next();
                stillValid = false;
                for (Job newJob : this.jobList) {
                    if (!thisJob.equals((Object)newJob)) continue;
                    stillValid = true;
                    continue block2;
                }
            }
            if (!allValid) {
                this.reload();
            }
        }
    }

    public void remove(String id) {
    }

    public void control(String control, String msg) {
    }
}

