/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class Console
extends JFrame {
    JTextArea output;
    JScrollPane scroll;
    JTextField input;
    JButton sendButton;
    JButton toFileButton;
    FileWriter logFile;
    ConsoleConnection connection;
    ConsoleInputListener specialKeyHandler;
    JFileChooser scriptLoader = new JFileChooser();
    static int bufferSize = Gateway.getProperties().getInt("Console.bufferSize", 200);
    protected LinkedList<String> cmdHistory = new LinkedList();

    public Console(String host, int port) {
        super("Cristal Console - " + host);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        this.output = new JTextArea("Enter 'help()' for help. . .\n");
        this.output.setEditable(false);
        this.input = new JTextField();
        this.setSize(400, 600);
        this.sendButton = new JButton("Send");
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.this.submit();
            }
        });
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JTextArea jTextArea = Console.this.output;
                synchronized (jTextArea) {
                    Console.this.output.setText("");
                }
            }
        });
        this.toFileButton = new JButton("Save");
        this.toFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Console.this.logFile == null) {
                    int returnValue = Console.this.scriptLoader.showSaveDialog(null);
                    switch (returnValue) {
                        case 0: {
                            try {
                                Console.this.logFile = new FileWriter(Console.this.scriptLoader.getSelectedFile());
                                Console.this.print("Starting writing log to " + Console.this.scriptLoader.getSelectedFile().getAbsolutePath());
                            }
                            catch (Exception ex) {
                                Console.this.print(ex.getClass().getName() + ": " + ex.getMessage());
                                Logger.error((Throwable)ex);
                            }
                            Console.this.toFileButton.setText("Stop");
                        }
                    }
                } else {
                    try {
                        Console.this.logFile.close();
                    }
                    catch (Exception ex) {
                        Console.this.logFile = null;
                        Console.this.print(ex.getClass().getName() + ": " + ex.getMessage());
                    }
                    Console.this.logFile = null;
                    Console.this.toFileButton.setText("Save");
                }
            }
        });
        this.specialKeyHandler = new ConsoleInputListener(this);
        this.input.addKeyListener(this.specialKeyHandler);
        this.scroll = new JScrollPane(this.output);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(this.scroll, c);
        this.getContentPane().add(this.scroll);
        Box inputBox = Box.createHorizontalBox();
        inputBox.add(this.input);
        inputBox.add(Box.createHorizontalStrut(5));
        inputBox.add(this.sendButton);
        inputBox.add(clearButton);
        inputBox.add(this.toFileButton);
        c.gridy = 1;
        c.fill = 2;
        c.weighty = 0.0;
        gridbag.setConstraints(inputBox, c);
        this.getContentPane().add(inputBox);
        try {
            Properties utilProps = FileStringUtility.loadConfigFile((String)Gateway.getResource().findTextResource("ScriptUtils.conf"));
            Box utilBox = Box.createHorizontalBox();
            for (Object name2 : utilProps.keySet()) {
                String name = (String)name2;
                String value = utilProps.getProperty(name);
                JButton newUtil = new JButton(name);
                newUtil.setActionCommand(value);
                newUtil.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Console.this.processUtil(e.getActionCommand());
                    }
                });
                utilBox.add(newUtil);
                utilBox.add(Box.createHorizontalStrut(5));
            }
            ++c.gridy;
            gridbag.setConstraints(utilBox, c);
            this.getContentPane().add(utilBox);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validate();
        this.connection = new ConsoleConnection(host, port, this);
        new Thread(this.connection).start();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (Console.this.connection != null) {
                    Console.this.connection.shutdown();
                }
                Console.this.dispose();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.input.requestFocus();
        }
    }

    public void processUtil(String command) {
        int replace;
        String text = this.input.getText();
        while ((replace = command.indexOf("%s")) > -1) {
            command = command.substring(0, replace) + text + command.substring(replace + 2);
        }
        this.connection.sendCommand(command);
    }

    public void submit() {
        this.connection.sendCommand(this.input.getText());
        this.input.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String line) {
        JTextArea jTextArea = this.output;
        synchronized (jTextArea) {
            String currentText = this.output.getText() + line + "\n";
            while (this.output.getLineCount() > bufferSize) {
                currentText = currentText.substring(currentText.indexOf("\n") + 1);
                this.output.setText(currentText);
            }
            this.output.setText(currentText);
            this.output.setCaretPosition(this.output.getText().length());
            if (this.logFile != null) {
                try {
                    this.logFile.write(line + "\n");
                }
                catch (IOException ex) {
                    this.logFile = null;
                    this.print("Error writing to file.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        JTextArea jTextArea = this.output;
        synchronized (jTextArea) {
            this.output.append("Lost connection");
        }
        this.output.setEnabled(false);
        this.input.setEnabled(false);
        this.sendButton.setEnabled(false);
    }

    private class ConsoleConnection
    implements Runnable {
        String host;
        int port;
        Console parent;
        boolean keepConnected = true;
        Socket conn;
        PrintWriter consoleOutput;
        BufferedReader consoleInput;

        public ConsoleConnection(String host, int port, Console parent) {
            Thread.currentThread().setName("Console Client to " + host + ":" + port);
            this.host = host;
            this.port = port;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.connect();
            while (this.keepConnected) {
                try {
                    String line = this.consoleInput.readLine();
                    if (line == null) {
                        this.parent.disable();
                        this.keepConnected = false;
                        continue;
                    }
                    this.parent.print(line);
                }
                catch (InterruptedIOException line) {
                }
                catch (IOException ex) {
                    this.parent.disable();
                    this.keepConnected = false;
                }
            }
            try {
                this.conn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void sendCommand(String command) {
            this.consoleOutput.println(command);
            if (!command.equals(Console.this.cmdHistory.peekFirst())) {
                Console.this.cmdHistory.push(command);
            }
            Console.this.specialKeyHandler.resetHistoryIndex();
        }

        public void shutdown() {
            this.keepConnected = false;
        }

        public void connect() {
            this.parent.print("Connecting to " + this.host + ":" + this.port);
            try {
                this.conn = new Socket(this.host, this.port);
                this.conn.setKeepAlive(true);
                this.conn.setSoTimeout(500);
                this.consoleOutput = new PrintWriter(this.conn.getOutputStream(), true);
                this.consoleInput = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ConsoleInputListener
    extends KeyAdapter {
        Console parent;
        int cmdIndex = -1;

        public ConsoleInputListener(Console parent) {
            this.parent = parent;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.parent.submit();
            } else if ((e.getKeyCode() == 38 || e.getKeyCode() == 224) && this.cmdIndex + 1 < Console.this.cmdHistory.size()) {
                this.parent.input.setText(Console.this.cmdHistory.get(++this.cmdIndex));
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                if (this.cmdIndex > 0) {
                    this.parent.input.setText(Console.this.cmdHistory.get(--this.cmdIndex));
                } else {
                    this.parent.input.setText("");
                }
            }
        }

        public void resetHistoryIndex() {
            this.cmdIndex = -1;
        }
    }
}

