/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class ImageLoader {
    private static Hashtable<String, ImageIcon> imgCache = new Hashtable();
    public static final ImageIcon nullImg = new ImageIcon(new byte[]{0});
    private static final ArrayList<String> reportedMissingIcons = new ArrayList();

    public static ImageIcon findImage(String resName) {
        try {
            for (String ns : Gateway.getResource().getModuleBaseURLs().keySet()) {
                try {
                    return ImageLoader.getImage(ns, resName);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                }
            }
            return ImageLoader.getImage(null, resName);
        }
        catch (ObjectNotFoundException ex) {
            if (!reportedMissingIcons.contains(resName)) {
                Logger.warning((String)("Image '" + resName + "' not found. Using null icon"), (Object[])new Object[0]);
                reportedMissingIcons.add(resName);
            }
            return nullImg;
        }
    }

    public static ImageIcon getImage(String ns, String resName) throws ObjectNotFoundException {
        ImageIcon newImg;
        if (resName == null) {
            return nullImg;
        }
        if (imgCache.containsKey(ns + '/' + resName)) {
            return imgCache.get(ns + '/' + resName);
        }
        URL imgLocation = null;
        if (ns == null) {
            try {
                imgLocation = Gateway.getResource().getKernelResourceURL("images/" + resName);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            try {
                imgLocation = Gateway.getResource().getModuleResourceURL(ns, "images/" + resName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (imgLocation != null && (newImg = new ImageIcon(imgLocation)).getIconHeight() > -1) {
            imgCache.put(ns + '/' + resName, newImg);
            Logger.msg((int)3, (String)("Loaded " + resName + " " + newImg.getIconWidth() + "x" + newImg.getIconHeight()), (Object[])new Object[0]);
            return newImg;
        }
        throw new ObjectNotFoundException();
    }
}

