/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.collection;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.cristalise.gui.DomainKeyConsumer;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.graph.view.SelectedVertexPanel;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;

public class SelectedMemberPanel
extends SelectedVertexPanel
implements DomainKeyConsumer {
    JLabel slotNumber = new JLabel();
    JTextField memberKey = new JTextField(14);
    JButton findButton = new JButton("Find");
    JToggleButton changeButton = new JToggleButton("Change");
    JButton removeButton = new JButton("Remove");
    SelectedMemberPanel me = this;
    AggregationMember selectedMember = null;

    public SelectedMemberPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel attrs = new JPanel(new GridLayout(3, 2));
        attrs.add(new JLabel("Slot Number:"));
        attrs.add(this.slotNumber);
        attrs.add(new JLabel("Assigned Member:"));
        attrs.add(this.memberKey);
        this.memberKey.setEditable(false);
        this.add(attrs);
        this.add(Box.createVerticalStrut(10));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String code = SelectedMemberPanel.this.memberKey.getText();
                if (code == null || code.length() == 0) {
                    code = SelectedMemberPanel.this.memberKey.getText().replace('/', ' ');
                }
                MainFrame.itemFinder.pushNewKey(code);
            }
        });
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SelectedMemberPanel.this.changeButton.getModel().isSelected()) {
                    MainFrame.itemFinder.setConsumer(SelectedMemberPanel.this.me, "Assign");
                    SelectedMemberPanel.this.findButton.setEnabled(false);
                } else {
                    MainFrame.itemFinder.clearConsumer(SelectedMemberPanel.this.me);
                    if (SelectedMemberPanel.this.selectedMember.getItemPath() != null) {
                        SelectedMemberPanel.this.findButton.setEnabled(true);
                    }
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectedMemberPanel.this.selectedMember.clearItem();
                SelectedMemberPanel.this.selectedMember.getProperties().remove((Object)"Name");
                SelectedMemberPanel.this.select((Vertex)SelectedMemberPanel.this.selectedMember);
            }
        });
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this.findButton);
        if (MainFrame.isAdmin) {
            buttonBox.add(this.changeButton);
            buttonBox.add(this.removeButton);
        }
        this.setButtons(false);
        this.add(buttonBox);
    }

    @Override
    public void select(Vertex vert) {
        this.selectedMember = (AggregationMember)vert;
        this.slotNumber.setText(String.valueOf(vert.getID()));
        ItemPath memberPath = this.selectedMember.getItemPath();
        String name = "Empty";
        if (memberPath != null) {
            try {
                ItemProxy member = Gateway.getProxyManager().getProxy((Path)memberPath);
                name = member.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.memberKey.setText(name);
        this.setButtons(true);
        this.revalidate();
    }

    @Override
    public void clear() {
        this.slotNumber.setText("");
        this.memberKey.setText("");
        this.setButtons(false);
        this.revalidate();
    }

    public void setButtons(boolean state) {
        this.findButton.setEnabled(state);
        this.changeButton.getModel().setSelected(false);
        this.changeButton.setEnabled(state);
        this.removeButton.setEnabled(state);
        MainFrame.itemFinder.clearConsumer(this.me);
    }

    @Override
    public void push(DomainPath key) {
        try {
            this.selectedMember.assignItem(key.getItemPath(), null);
            this.select((Vertex)this.selectedMember);
        }
        catch (InvalidCollectionModification ex) {
            JOptionPane.showMessageDialog(null, "Item does not fit in this slot", "Error", 0);
        }
        catch (ObjectNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Not an item - cannot assign", "Error", 0);
        }
    }

    @Override
    public void push(String name) {
        JOptionPane.showMessageDialog(null, "Item is not known in this centre", "Error", 0);
    }
}

