/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import org.cristalise.gui.graph.event.SelectionChangedEvent;
import org.cristalise.gui.graph.view.GraphPanel;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.Vertex;

public class DeletionController
extends KeyAdapter
implements Observer,
ActionListener {
    private GraphModelManager mGraphModelManager = null;
    private GraphPanel mGraphPanel = null;
    private JButton mDeleteButton = null;

    public void setGraphModelManager(GraphModelManager graphModelManager) {
        this.mGraphModelManager = graphModelManager;
        this.mGraphModelManager.addObserver((Observer)this);
    }

    public void setGraphPanel(GraphPanel graphPanel) {
        this.mGraphPanel = graphPanel;
    }

    public void setDeleteButton(JButton deleteButton) {
        this.mDeleteButton = deleteButton;
        this.mDeleteButton.addActionListener(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        SelectionChangedEvent event = null;
        DirectedEdge selectedEdge = null;
        Vertex[] selectedVertices = null;
        if (arg instanceof SelectionChangedEvent && this.mDeleteButton != null && this.mGraphModelManager.isEditable()) {
            event = (SelectionChangedEvent)((Object)arg);
            selectedEdge = event.mSelection.mEdge;
            selectedVertices = event.mSelection.mVertices;
            this.mDeleteButton.setEnabled(selectedEdge != null || selectedVertices != null);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.mGraphModelManager.isEditable()) {
            this.mGraphPanel.deleteSelection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.mGraphModelManager != null && this.mGraphModelManager.isEditable()) {
            this.mGraphPanel.deleteSelection();
        }
    }
}

