/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tabs;

import java.util.StringTokenizer;
import javax.swing.JTabbedPane;
import org.cristalise.gui.tabs.ItemTabPane;
import org.cristalise.gui.tabs.collection.AggregationView;
import org.cristalise.gui.tabs.collection.CollectionView;
import org.cristalise.gui.tabs.collection.DependencyView;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class CollectionPane
extends ItemTabPane
implements ProxyObserver<Collection<? extends CollectionMember>> {
    JTabbedPane collTabs;

    public CollectionPane() {
        super("Collection", "Item Collection");
        this.createLayout();
    }

    public void add(Collection<? extends CollectionMember> contents) {
        Logger.msg((int)5, (String)("Got " + contents.getName() + ": " + contents.getClass().getName()), (Object[])new Object[0]);
        Logger.msg((int)7, (String)("Looking for existing " + contents.getName()), (Object[])new Object[0]);
        CollectionView thisCollView = this.findTabForCollName(contents.getName());
        if (contents instanceof Aggregation) {
            AggregationView thisAggView;
            if (thisCollView == null) {
                thisAggView = new AggregationView();
                thisAggView.setItem(this.sourceItem.getItem());
                thisCollView = thisAggView;
            } else {
                thisAggView = (AggregationView)thisCollView;
            }
            thisAggView.setCollection((Collection<AggregationMember>)((Aggregation)contents));
        } else if (contents instanceof Dependency) {
            DependencyView thisDepView;
            if (thisCollView == null) {
                thisDepView = new DependencyView();
                thisDepView.setItem(this.sourceItem.getItem());
                thisCollView = thisDepView;
            } else {
                thisDepView = (DependencyView)thisCollView;
            }
            thisDepView.setCollection((Collection<DependencyMember>)((Dependency)contents));
        } else {
            Logger.error((String)("Collection type " + contents.getClass().getName() + " not known"), (Object[])new Object[0]);
            return;
        }
        Logger.msg((int)3, (String)("Adding new " + thisCollView.getClass().getName()), (Object[])new Object[0]);
        this.collTabs.add(contents.getName() + (contents instanceof CollectionDescription ? "*" : ""), thisCollView);
    }

    public void remove(String id) {
    }

    private CollectionView<? extends CollectionMember> findTabForCollName(String collName) {
        CollectionView thisCollView = null;
        for (int i = 0; i < this.collTabs.getTabCount(); ++i) {
            thisCollView = (CollectionView)this.collTabs.getComponentAt(i);
            if (thisCollView.getCollection() == null || !collName.equals(thisCollView.getCollection().getName())) continue;
            return thisCollView;
        }
        return null;
    }

    protected void createLayout() {
        this.initPanel();
        this.collTabs = new JTabbedPane();
        this.add(this.collTabs);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Collection Loader");
        this.sourceItem.getItem().subscribe(new MemberSubscription((ProxyObserver)this, ClusterType.COLLECTION.getName(), false));
        try {
            String collNames = this.sourceItem.getItem().queryData(ClusterType.COLLECTION + "/all");
            StringTokenizer tok = new StringTokenizer(collNames, ",");
            while (tok.hasMoreTokens()) {
                Collection thisLastColl = (Collection)this.sourceItem.getItem().getObject(ClusterType.COLLECTION + "/" + tok.nextToken() + "/last");
                this.add((Collection<? extends CollectionMember>)thisLastColl);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            Logger.msg((int)2, (String)"Error loading collections", (Object[])new Object[0]);
        }
    }

    @Override
    public void reload() {
        Gateway.getStorage().clearCache(this.sourceItem.getItemPath(), ClusterType.COLLECTION.getName());
        this.collTabs.removeAll();
        this.initForItem(this.sourceItem);
    }

    public void control(String control, String msg) {
    }
}

