/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.tree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.cristalise.gui.ItemDetails;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.MainFrame;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeCollection;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class NodeItem
extends Node
implements Transferable {
    protected ItemProxy myItem = null;
    Collection<? extends CollectionMember> parentCollection;
    Integer slotNo = null;
    static DataFlavor dataFlavor = new DataFlavor(NodeItem.class, "NodeItem");
    ItemProxy parentItem;
    static DataFlavor[] supportedFlavours = new DataFlavor[]{dataFlavor, new DataFlavor(Path.class, "Path"), DataFlavor.getTextPlainUnicodeFlavor()};

    public NodeItem(Path path, ItemTabManager desktop) {
        super(path, desktop);
        Logger.msg((int)2, (String)("NodeEntity.<init> - Creating item for '" + path.toString() + "'."), (Object[])new Object[0]);
        try {
            this.myItem = Gateway.getProxyManager().getProxy(path);
            this.itemPath = path.getItemPath();
            Logger.msg((int)2, (String)("NodeEntity.<init> - System key is " + this.itemPath), (Object[])new Object[0]);
            String alias = this.myItem.getName();
            if (alias != null) {
                this.name = alias;
            }
            try {
                this.type = this.myItem.getProperty("Type");
            }
            catch (ObjectNotFoundException e) {
                this.type = "";
            }
            String iconString = this.type;
            if ("ActivityDesc".equals(this.type)) {
                try {
                    iconString = this.myItem.getProperty("Complexity") + iconString;
                }
                catch (ObjectNotFoundException e) {
                    iconString = "error";
                }
            }
            if (iconString != null) {
                this.setIcon(iconString.toLowerCase());
            }
        }
        catch (ObjectNotFoundException e1) {
            this.itemPath = null;
            this.type = "Error";
            this.name = "Entity not found";
            this.setIcon("error");
        }
        this.createTreeNode();
        this.makeExpandable();
    }

    public ItemProxy getItem() {
        return this.myItem;
    }

    public void openItem() {
        this.desktop.add(this);
    }

    public Collection<? extends CollectionMember> getParentCollection() {
        return this.parentCollection;
    }

    public Integer getSlotNo() {
        return this.slotNo;
    }

    public void setCollection(Collection<? extends CollectionMember> parentCollection, Integer slotNo, ItemProxy parentItem) {
        this.parentCollection = parentCollection;
        this.slotNo = slotNo;
        this.parentItem = parentItem;
    }

    @Override
    public void loadChildren() {
        try {
            String collections = this.myItem.queryData("Collection/all");
            StringTokenizer tok = new StringTokenizer(collections, ",");
            while (tok.hasMoreTokens()) {
                NodeCollection newCollection = new NodeCollection(this.myItem, tok.nextToken(), this.desktop);
                this.add(newCollection);
            }
            this.end(false);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu popup = super.getPopupMenu();
        JMenuItem openItem = new JMenuItem("Open");
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeItem.this.openItem();
            }
        });
        popup.addSeparator();
        popup.add(openItem);
        popup.addSeparator();
        if (this.parentCollection != null && MainFrame.isAdmin) {
            JMenuItem collMenuItem = new JMenuItem("Remove from collection");
            collMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] params = new String[]{NodeItem.this.parentCollection.getName(), String.valueOf(NodeItem.this.slotNo)};
                    String predefStepName = NodeItem.this.parentCollection instanceof Aggregation ? "ClearSlot" : "RemoveSlotFromCollection";
                    try {
                        MainFrame.userAgent.execute(NodeItem.this.parentItem, predefStepName, params);
                    }
                    catch (Exception e1) {
                        MainFrame.exceptionDialog(e1);
                    }
                }
            });
            popup.add(collMenuItem);
            popup.addSeparator();
        }
        try {
            ArrayList jobList = this.myItem.getJobList(MainFrame.userAgent);
            ArrayList<String> already = new ArrayList<String>();
            if (jobList.size() > 0) {
                for (Job thisJob : jobList) {
                    String stepName = thisJob.getStepName();
                    if (already.contains(stepName)) continue;
                    already.add(stepName);
                    JMenuItem menuItem = new JMenuItem(stepName);
                    menuItem.setActionCommand(stepName);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            NodeItem.this.execute(e.getActionCommand());
                        }
                    });
                    popup.add(menuItem);
                }
            } else {
                JMenuItem noAct = new JMenuItem("No activities");
                noAct.setEnabled(false);
                popup.add(noAct);
            }
        }
        catch (Exception ex) {
            JMenuItem error = new JMenuItem("Error querying jobs");
            error.setEnabled(false);
            popup.add(error);
        }
        return popup;
    }

    public void execute(String stepName) {
        ItemDetails thisDetail = this.desktop.add(this);
        thisDetail.runCommand("Execution", stepName);
    }

    public ArrayList<String> getTabs() {
        ArrayList<String> requiredTabs = new ArrayList<String>();
        requiredTabs.add("Properties");
        try {
            String collNames = this.myItem.queryData(ClusterType.COLLECTION + "/all");
            if (collNames.length() > 0) {
                requiredTabs.add("Collection");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        requiredTabs.add("Execution");
        requiredTabs.add("History");
        requiredTabs.add("Viewpoint");
        requiredTabs.add("Workflow");
        return requiredTabs;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supportedFlavours;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor flavour : supportedFlavours) {
            if (!flavour.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(supportedFlavours[0])) {
            return this;
        }
        if (flavor.equals(supportedFlavours[1])) {
            return this.binding;
        }
        if (flavor.equals(supportedFlavours[2])) {
            return this.name;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

