/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.ItemTabManager;
import org.cristalise.gui.tree.Node;
import org.cristalise.gui.tree.NodeCollectionMember;
import org.cristalise.gui.tree.NodeSubscriber;
import org.cristalise.kernel.lookup.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTreeBuilder
extends Node
implements NodeSubscriber {
    private static final Logger log = LoggerFactory.getLogger(DynamicTreeBuilder.class);
    private DefaultTreeModel treeModel;
    private final DefaultMutableTreeNode parent;
    public short state = 0;
    public static final short IDLE = 0;
    public static final short LOADING = 1;
    public static final short PARTIAL = 2;
    public static final short FINISHED = 3;
    private final DefaultMutableTreeNode loading;
    private static ImageIcon loadIcon = ImageLoader.findImage("loading.gif");
    private static ImageIcon pauseIcon = ImageLoader.findImage("reload.gif");

    public DynamicTreeBuilder(DefaultMutableTreeNode parent, ItemTabManager desktop) {
        super(desktop);
        this.parent = parent;
        this.loading = new DefaultMutableTreeNode(this);
    }

    public void buildInfo(JTree parentTree) {
        this.treeModel = (DefaultTreeModel)parentTree.getModel();
    }

    public void start() {
        Node parentNode = (Node)this.parent.getUserObject();
        log.info("start() - Filling in children of '" + parentNode.toString() + "'");
        if (this.state == 0) {
            parentNode.subscribeNode(this);
        } else {
            parentNode.loadMore();
        }
        this.state = 1;
    }

    @Override
    public String toString() {
        switch (this.state) {
            case 0: {
                return "Initializing Tree Node Loader";
            }
            case 1: {
                return "Loading . . .";
            }
            case 2: {
                return "Double-click to load more";
            }
            case 3: {
                return "Done";
            }
        }
        return "";
    }

    @Override
    public ImageIcon getIcon() {
        if (this.state == 1) {
            return loadIcon;
        }
        return pauseIcon;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.loading;
    }

    @Override
    public void add(Node newNode) {
        log.info("add() - Received item for tree. Name: " + newNode);
        SwingUtilities.invokeLater(new TreeAddThread(newNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(boolean more) {
        if (more) {
            this.state = (short)2;
        } else {
            this.state = (short)3;
            DefaultTreeModel defaultTreeModel = this.treeModel;
            synchronized (defaultTreeModel) {
                if (this.loading.getParent() != null) {
                    SwingUtilities.invokeLater(new TreeRemoveThread(this.loading));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Path path) {
        DefaultTreeModel defaultTreeModel = this.treeModel;
        synchronized (defaultTreeModel) {
            for (int i = 0; i < this.parent.getChildCount(); ++i) {
                Node childNode;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.treeModel.getChild(this.parent, i);
                if (!(child.getUserObject() instanceof Node) || !(childNode = (Node)child.getUserObject()).getPath().equals((Object)path)) continue;
                SwingUtilities.invokeLater(new TreeRemoveThread(child));
                return;
            }
        }
    }

    @Override
    public void loadChildren() {
    }

    class TreeAddThread
    implements Runnable {
        Node newNode;

        TreeAddThread(Node newNode) {
            this.newNode = newNode;
        }

        @Override
        public void run() {
            boolean inserted = false;
            DefaultMutableTreeNode newTreeNode = this.newNode.getTreeNode();
            for (int i = 0; i < DynamicTreeBuilder.this.parent.getChildCount() && !inserted; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)DynamicTreeBuilder.this.treeModel.getChild(DynamicTreeBuilder.this.parent, i);
                if (child == DynamicTreeBuilder.this.loading) continue;
                Node childNode = (Node)child.getUserObject();
                if (childNode.getName().equals(this.newNode.getName())) {
                    if (this.newNode instanceof NodeCollectionMember) {
                        NodeCollectionMember newCollMember = (NodeCollectionMember)this.newNode;
                        NodeCollectionMember childCollMember = (NodeCollectionMember)childNode;
                        if (childCollMember.getSlotNo() == newCollMember.getSlotNo()) {
                            log.debug("run() - already have node:'{}(slotId:{})' - SKIPPING", (Object)this.newNode, (Object)newCollMember.getMember().getID());
                            inserted = true;
                            break;
                        }
                    } else {
                        log.debug("run() - already have node:'{}' - SKIPPING", (Object)this.newNode);
                        inserted = true;
                        break;
                    }
                }
                if (childNode.getName().compareTo(this.newNode.getName()) < 0) continue;
                log.info("run() - insert the node '{}' before index:{}", (Object)this.newNode, (Object)i);
                DynamicTreeBuilder.this.treeModel.insertNodeInto(newTreeNode, DynamicTreeBuilder.this.parent, i);
                inserted = true;
                break;
            }
            if (!inserted) {
                DynamicTreeBuilder.this.treeModel.insertNodeInto(newTreeNode, DynamicTreeBuilder.this.parent, DynamicTreeBuilder.this.parent.getChildCount());
            }
        }
    }

    class TreeRemoveThread
    implements Runnable {
        DefaultMutableTreeNode oldNode;

        TreeRemoveThread(DefaultMutableTreeNode oldNode) {
            this.oldNode = oldNode;
        }

        @Override
        public void run() {
            DynamicTreeBuilder.this.treeModel.removeNodeFromParent(this.oldNode);
        }
    }
}

