/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui;

import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.cristalise.gui.DomainKeyConsumer;
import org.cristalise.gui.DomainKeyListener;
import org.cristalise.gui.ImageLoader;
import org.cristalise.gui.MainFrame;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemFinder
extends Box
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ItemFinder.class);
    JTextField inputField;
    JButton findButton;
    JButton findNextButton;
    GridBagLayout gridbag = new GridBagLayout();
    Lookup lookup = Gateway.getLookup();
    DomainKeyConsumer defaultConsumer = null;
    DomainKeyConsumer currentConsumer = null;
    Iterator<?> matches;
    Path rootNode = new DomainPath();
    protected static ImageIcon mFindIcon = null;
    protected static ImageIcon mNextIcon = null;

    public ItemFinder() {
        super(0);
        this.initPanel();
    }

    public void pushNewKey(String key) {
        this.inputField.setText(key);
        this.runSearch();
    }

    public void setDefaultConsumer(DomainKeyConsumer newConsumer) {
        this.defaultConsumer = newConsumer;
        this.currentConsumer = newConsumer;
    }

    public DomainKeyConsumer getDefaultConsumer() {
        return this.defaultConsumer;
    }

    public void setConsumer(DomainKeyConsumer newConsumer, String label) {
        this.currentConsumer = newConsumer;
        this.findButton.setText(label);
    }

    public void clearConsumer(DomainKeyConsumer oldConsumer) {
        if (this.currentConsumer == oldConsumer) {
            this.currentConsumer = this.defaultConsumer;
            this.findButton.setText("");
        }
    }

    private void initPanel() {
        JLabel search = new JLabel("Search:");
        this.add(search);
        this.add(Box.createHorizontalStrut(7));
        this.inputField = new JTextField(20);
        this.add(this.inputField);
        this.add(Box.createHorizontalStrut(5));
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFinder.this.pushNewKey(ItemFinder.this.inputField.getText());
            }
        });
        this.findButton = new JButton(mFindIcon);
        this.findButton.setMargin(new Insets(2, 5, 2, 5));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFinder.this.pushNewKey(ItemFinder.this.inputField.getText());
            }
        });
        this.add(this.findButton);
        this.add(Box.createHorizontalStrut(5));
        this.findNextButton = new JButton(mNextIcon);
        this.findNextButton.setMargin(new Insets(2, 5, 2, 5));
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFinder.this.nextMatch();
            }
        });
        this.findNextButton.setEnabled(false);
        this.add(this.findNextButton);
        this.add(Box.createHorizontalStrut(15));
        log.debug("creating plugins");
        String requiredListeners = Gateway.getProperties().getString("DomainKeyListeners");
        if (requiredListeners != null) {
            StringTokenizer tok = new StringTokenizer(requiredListeners, ",");
            while (tok.hasMoreTokens()) {
                String listenerName = tok.nextToken();
                log.debug("creating a " + listenerName);
                try {
                    Class<?> listenerClass = Class.forName(listenerName);
                    DomainKeyListener newListener = (DomainKeyListener)listenerClass.newInstance();
                    newListener.init();
                    newListener.setConsumer(this);
                    JToggleButton listenerButton = new JToggleButton(newListener.getIcon(), false);
                    listenerButton.addItemListener(new ListenerButtonListener(newListener, listenerButton));
                    listenerButton.setMargin(new Insets(0, 2, 0, 2));
                    listenerButton.setToolTipText("Enable " + newListener.getDescription());
                    this.add(listenerButton);
                    this.add(Box.createHorizontalStrut(7));
                }
                catch (Exception e) {
                    log.error("ItemFinder() - could not create a " + listenerName + ": ", (Throwable)e);
                }
            }
            this.add(Box.createHorizontalGlue());
        }
    }

    private void runSearch() {
        Thread searcher = new Thread(this);
        searcher.start();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Entity Search");
        String searchTerm = this.inputField.getText();
        if (searchTerm.length() == 0) {
            return;
        }
        this.findButton.setEnabled(false);
        this.findNextButton.setEnabled(false);
        MainFrame.progress.startBouncing("Searching. Please Wait");
        this.findNextButton.setEnabled(false);
        String term = this.inputField.getText();
        this.matches = this.lookup.search(this.rootNode, term);
        if (!this.matches.hasNext()) {
            MainFrame.progress.stopBouncing("No results");
            this.currentConsumer.push(searchTerm);
            this.findButton.setEnabled(true);
            return;
        }
        MainFrame.progress.stopBouncing("Selecting first match.");
        this.nextMatch();
    }

    void nextMatch() {
        this.findButton.setEnabled(false);
        this.findNextButton.setEnabled(false);
        DomainPath nextMatch = (DomainPath)this.matches.next();
        try {
            this.currentConsumer.push(nextMatch);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.findButton.setEnabled(true);
        this.findNextButton.setToolTipText("Click to show next match");
        if (this.matches.hasNext()) {
            this.findNextButton.setEnabled(true);
        }
    }

    static {
        try {
            mNextIcon = ImageLoader.findImage("next.png");
            mFindIcon = ImageLoader.findImage("find.png");
        }
        catch (Exception e) {
            log.error("Couldn't load images", (Throwable)e);
        }
    }

    private class ListenerButtonListener
    implements ItemListener {
        private final DomainKeyListener listener;
        private final JToggleButton listenerButton;

        public ListenerButtonListener(DomainKeyListener newListener, JToggleButton listenerButton) {
            this.listener = newListener;
            this.listenerButton = listenerButton;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                try {
                    if (!this.listener.enable()) {
                        this.listenerButton.doClick();
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Error initialising " + this.listener.getDescription(), 0);
                    this.listenerButton.doClick();
                }
                this.listenerButton.setToolTipText("Disable " + this.listener.getDescription());
            } else {
                this.listener.disable();
                this.listenerButton.setToolTipText("Enable " + this.listener.getDescription());
            }
        }
    }
}

