/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.gui.graph.controller;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.cristalise.gui.graph.controller.ElasticBand;
import org.cristalise.gui.graph.controller.Selection;
import org.cristalise.gui.graph.view.EditorModeListener;
import org.cristalise.gui.graph.view.GraphPanel;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;

public class MultiSelectionDragController
extends MouseAdapter
implements EditorModeListener,
KeyListener {
    private ResizeInf mResizeInf = new ResizeInf();
    private DispForSelection mDispForSelection = null;
    protected GraphModelManager mGraphModelManager = null;
    private GraphPanel mGraphPanel = null;
    protected final Integer kOtherMode = new Integer(0);
    protected final Integer kWaiting = new Integer(1);
    protected final Integer kResizing = new Integer(2);
    protected final Integer kDraggingSelection = new Integer(3);
    protected final Integer kStretching = new Integer(4);
    protected final int kSelectEntered = 0;
    protected final int kOtherEntered = 1;
    protected final int kPressOnEdge = 2;
    protected final int kPressOnVertex = 3;
    protected final int kPressOnSelection = 4;
    protected final int kPressOnResizePad = 5;
    protected final int kCTRLPressOnVertex = 6;
    protected final int kCTRL_A = 7;
    protected final int kPressOnNothing = 8;
    protected final int kDrag = 9;
    protected final int kRelease = 10;
    protected final int kZoomIn = 11;
    protected Action mStoreResizeInf = new Action(){

        @Override
        public void doIt(Object data) {
            Point mousePoint = (Point)data;
            GraphPoint centre = null;
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mMousePressedX = mousePoint.x;
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mMousePressedY = mousePoint.y;
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mSelectedVertex = ((MultiSelectionDragController)MultiSelectionDragController.this).mGraphPanel.getSelection().mVertices[0];
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline = ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mSelectedVertex.getOutlinePoints();
            centre = ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mSelectedVertex.getCentrePoint();
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mCentreX = centre.x;
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mCentreY = centre.y;
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldHeight = ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mSelectedVertex.getHeight();
            ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldWidth = ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mSelectedVertex.getWidth();
        }
    };
    protected Action mResizeVertex = new Action(){

        @Override
        public void doIt(Object data) {
            Point mousePoint = (Point)data;
            int resizeX = 0;
            int resizeY = 0;
            resizeX = mousePoint.x - ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mMousePressedX;
            resizeY = mousePoint.y - ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mMousePressedY;
            if (resizeX < -((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldWidth / 2 + 10) {
                resizeX = -((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldWidth / 2 + 10;
            }
            if (resizeY < -((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldHeight / 2 + 10) {
                resizeY = -((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldHeight / 2 + 10;
            }
            if (MultiSelectionDragController.this.mGraphModelManager.isEditable()) {
                ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mSelectedVertex.setOutlinePoints(this.newOutline(resizeX, resizeY));
                MultiSelectionDragController.this.mGraphModelManager.forceNotify();
            }
        }

        private GraphPoint[] newOutline(int resizeX, int resizeY) {
            GraphPoint[] newOutline = new GraphPoint[((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline.length];
            int x = 0;
            int y = 0;
            int i = 0;
            for (i = 0; i < newOutline.length; ++i) {
                x = ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].x > ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mCentreX ? ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].x + resizeX : (((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].x < ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mCentreX ? ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].x - resizeX : ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].x);
                y = ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].y > ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mCentreY ? ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].y + resizeY : (((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].y < ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mCentreY ? ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].y - resizeY : ((MultiSelectionDragController)MultiSelectionDragController.this).mResizeInf.mOldOutline[i].y);
                newOutline[i] = new GraphPoint(x, y);
            }
            return newOutline;
        }
    };
    protected Action mSelectEdge = new Action(){

        @Override
        public void doIt(Object data) {
            Selection selection = new Selection((DirectedEdge)data, null, 0, 0, 0, 0);
            MultiSelectionDragController.this.mGraphPanel.setSelection(selection);
        }
    };
    protected Action mSelectVertexAndStoreDisp = new Action(){

        @Override
        public void doIt(Object data) {
            VertexAndDisp vertexAndDisp = (VertexAndDisp)data;
            GraphPoint centrePoint = vertexAndDisp.mVertex.getCentrePoint();
            Selection selection = new Selection(null, new Vertex[]{vertexAndDisp.mVertex}, centrePoint.x, centrePoint.y, centrePoint.x, centrePoint.y);
            MultiSelectionDragController.this.mGraphPanel.setSelection(selection);
            MultiSelectionDragController.this.mDispForSelection = new DispForSelection();
            ((MultiSelectionDragController)MultiSelectionDragController.this).mDispForSelection.mXDisp = vertexAndDisp.mXDisp;
            ((MultiSelectionDragController)MultiSelectionDragController.this).mDispForSelection.mYDisp = vertexAndDisp.mYDisp;
        }
    };
    protected Action mStoreDisp = new Action(){

        @Override
        public void doIt(Object data) {
            MultiSelectionDragController.this.mDispForSelection = (DispForSelection)data;
        }
    };
    protected Action mToggleVertex = new Action(){

        @Override
        public void doIt(Object data) {
            Vertex vertex = (Vertex)data;
            if (MultiSelectionDragController.this.mGraphPanel.inSelection(vertex)) {
                MultiSelectionDragController.this.mGraphPanel.removeFromSelection(vertex);
            } else {
                MultiSelectionDragController.this.mGraphPanel.addToSelection(vertex);
            }
        }
    };
    protected Action mSelectAll = new Action(){

        @Override
        public void doIt(Object data) {
            MultiSelectionDragController.this.mGraphPanel.selectAll();
        }
    };
    protected Action mCreateBand = new Action(){

        @Override
        public void doIt(Object data) {
            Point mouse = (Point)data;
            GraphPoint fixedCorner = new GraphPoint(mouse.x, mouse.y);
            MultiSelectionDragController.this.mGraphPanel.setElasticBand(new ElasticBand(fixedCorner, fixedCorner));
        }
    };
    protected Action mMoveSelection = new Action(){

        @Override
        public void doIt(Object data) {
            Point mousePoint = (Point)data;
            int topLeftX = mousePoint.x - ((MultiSelectionDragController)MultiSelectionDragController.this).mDispForSelection.mXDisp;
            int topLeftY = mousePoint.y - ((MultiSelectionDragController)MultiSelectionDragController.this).mDispForSelection.mYDisp;
            if (MultiSelectionDragController.this.mGraphModelManager.isEditable()) {
                MultiSelectionDragController.this.mGraphPanel.moveAbsoluteSelection(topLeftX, topLeftY);
            }
        }
    };
    protected Action mResizeBand = new Action(){

        @Override
        public void doIt(Object data) {
            Point mouse = (Point)data;
            MultiSelectionDragController.this.mGraphPanel.resizeElasticBand(new GraphPoint(mouse.x, mouse.y));
        }
    };
    protected Action mSelectContents = new Action(){

        @Override
        public void doIt(Object data) {
            MultiSelectionDragController.this.mGraphPanel.selectContentsOfElasticBand();
        }
    };
    protected Action mZoomIn = new Action(){

        @Override
        public void doIt(Object data) {
            Vertex zoomTo;
            if (data instanceof Vertex && ((GraphableVertex)(zoomTo = (Vertex)data)).getIsComposite()) {
                MultiSelectionDragController.this.mGraphModelManager.zoomIn(zoomTo);
            }
        }
    };
    protected Object[][][] mFSTN = new Object[][][]{{{null, this.kWaiting}, null, null, null, null}, {null, {null, this.kOtherMode}, null, null, null}, {null, {this.mSelectEdge, null}, null, null, null}, {null, {this.mSelectVertexAndStoreDisp, this.kDraggingSelection}, null, null, null}, {null, {this.mStoreDisp, this.kDraggingSelection}, null, null, null}, {null, {this.mStoreResizeInf, this.kResizing}, null, null, null}, {null, {this.mToggleVertex, null}, null, null, null}, {null, {this.mSelectAll, null}, null, null, null}, {null, {this.mCreateBand, this.kStretching}, null, null, null}, {null, null, {this.mResizeVertex, null}, {this.mMoveSelection, null}, {this.mResizeBand, null}}, {null, null, {null, this.kWaiting}, {null, this.kWaiting}, {this.mSelectContents, this.kWaiting}}, {null, {this.mZoomIn, null}, null, null, null}};
    private Integer mState = this.kWaiting;

    protected void processEvent(int event, Object data) {
        Object[] transition = this.mFSTN[event][this.mState];
        Action action = null;
        Integer nextState = null;
        if (transition != null) {
            action = (Action)transition[0];
            nextState = (Integer)transition[1];
            if (action != null) {
                action.doIt(data);
            }
            if (nextState != null) {
                this.mState = nextState;
            }
        }
    }

    public MultiSelectionDragController(GraphModelManager graphModelManager, GraphPanel graphPanel) {
        this.mGraphModelManager = graphModelManager;
        this.mGraphPanel = graphPanel;
    }

    @Override
    public void editorModeChanged(String idOfNewMode) {
        if (idOfNewMode.equals("Select")) {
            this.processEvent(0, null);
        } else {
            this.processEvent(1, null);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int modifiers = me.getModifiers();
        if (this.mGraphModelManager != null) {
            if ((modifiers & 2) == 0) {
                this.mousePressedWithoutCTRL(me.getPoint());
            } else {
                this.mousePressedWithCTRL(me.getPoint());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getClickCount() == 2) {
            Point clickedSpot = me.getPoint();
            GraphPoint mouseGPoint = new GraphPoint(clickedSpot.x, clickedSpot.y);
            Vertex clicked = this.mGraphPanel.getVertex(mouseGPoint);
            if (clicked != null) {
                this.processEvent(11, clicked);
            }
        }
    }

    private void mousePressedWithoutCTRL(Point mousePoint) {
        GraphPoint mouseGPoint = new GraphPoint(mousePoint.x, mousePoint.y);
        DirectedEdge edge = this.mGraphPanel.getEdge(mouseGPoint);
        Vertex vertex = this.mGraphPanel.getVertex(mouseGPoint);
        GraphPoint vertexCentrePoint = null;
        VertexAndDisp vertexAndDisp = null;
        Selection selection = null;
        DispForSelection dispForSelection = null;
        if (this.onResizePad(mouseGPoint)) {
            this.processEvent(5, mousePoint);
        } else if (vertex != null) {
            if (this.mGraphPanel.inSelection(vertex)) {
                selection = this.mGraphPanel.getSelection();
                dispForSelection = new DispForSelection();
                dispForSelection.mXDisp = mousePoint.x - selection.mTopLeftX;
                dispForSelection.mYDisp = mousePoint.y - selection.mTopLeftY;
                this.processEvent(4, dispForSelection);
            } else {
                vertexCentrePoint = vertex.getCentrePoint();
                vertexAndDisp = new VertexAndDisp();
                vertexAndDisp.mVertex = vertex;
                vertexAndDisp.mXDisp = mousePoint.x - vertexCentrePoint.x;
                vertexAndDisp.mYDisp = mousePoint.y - vertexCentrePoint.y;
                this.processEvent(3, vertexAndDisp);
            }
        } else if (edge == null) {
            this.processEvent(8, mousePoint);
        } else {
            this.processEvent(2, edge);
        }
    }

    private boolean onResizePad(GraphPoint mouseGPoint) {
        Selection selection = this.mGraphPanel.getSelection();
        GraphPoint vertexCentre = null;
        int bottomRightX = 0;
        int bottomRightY = 0;
        if (selection.mVertices == null) {
            return false;
        }
        if (selection.mVertices.length == 1) {
            vertexCentre = selection.mVertices[0].getCentrePoint();
            if (vertexCentre == null) {
                return false;
            }
            bottomRightX = vertexCentre.x + selection.mVertices[0].getWidth() / 2;
            bottomRightY = vertexCentre.y + selection.mVertices[0].getHeight() / 2;
            return mouseGPoint.x > bottomRightX && mouseGPoint.x < bottomRightX + 10 && mouseGPoint.y > bottomRightY && mouseGPoint.y < bottomRightY + 10;
        }
        return false;
    }

    private void mousePressedWithCTRL(Point mousePoint) {
        Vertex vertex = this.mGraphPanel.getVertex(new GraphPoint(mousePoint.x, mousePoint.y));
        if (vertex != null) {
            this.processEvent(6, vertex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.processEvent(10, null);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processEvent(9, e.getPoint());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 65 && e.isControlDown()) {
            this.processEvent(7, null);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class DispForSelection {
        public int mXDisp = 0;
        public int mYDisp = 0;

        private DispForSelection() {
        }
    }

    private class ResizeInf {
        public int mMousePressedX = 0;
        public int mMousePressedY = 0;
        public Vertex mSelectedVertex = null;
        public GraphPoint[] mOldOutline = null;
        public int mCentreX = 0;
        public int mCentreY = 0;
        public int mOldHeight = 0;
        public int mOldWidth = 0;

        private ResizeInf() {
        }
    }

    protected static interface Action {
        public void doIt(Object var1);
    }

    private class VertexAndDisp {
        public Vertex mVertex = null;
        public int mXDisp = 0;
        public int mYDisp = 0;

        private VertexAndDisp() {
        }
    }
}

